/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.test;

import io.github.microcks.domain.Header;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Secret;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.domain.TestResult;
import io.github.microcks.domain.TestReturn;
import io.github.microcks.util.URIBuilder;
import io.github.microcks.util.test.AbstractTestRunner;
import io.github.microcks.util.test.TestRunnerCommons;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;

public class HttpTestRunner
extends AbstractTestRunner<HttpMethod> {
    private static Logger log = LoggerFactory.getLogger(HttpTestRunner.class);
    private Secret secret;
    private ClientHttpRequestFactory clientHttpRequestFactory;
    private Map<String, Secret> cachedSecrets;

    public void setSecret(Secret secret) {
        this.secret = secret;
    }

    public void setClientHttpRequestFactory(ClientHttpRequestFactory clientHttpRequestFactory) {
        this.clientHttpRequestFactory = clientHttpRequestFactory;
    }

    @Override
    public List<TestReturn> runTest(Service service, Operation operation, TestResult testResult, List<Request> requests, String endpointUrl, HttpMethod method) throws URISyntaxException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("Launching test run on {} for {} request(s)", (Object)endpointUrl, (Object)requests.size());
        }
        if (requests.isEmpty()) {
            return null;
        }
        ArrayList<TestReturn> result = new ArrayList<TestReturn>();
        for (Request request : requests) {
            int code = 0;
            String message = null;
            Object customizedEndpointUrl = endpointUrl;
            if (service.getType().equals((Object)ServiceType.REST)) {
                String operationName = operation.getName();
                if (operationName.indexOf(32) > 0 && operationName.indexOf(32) < operationName.length()) {
                    operationName = operationName.split(" ")[1];
                }
                customizedEndpointUrl = (String)customizedEndpointUrl + URIBuilder.buildURIFromPattern(operationName, request.getQueryParameters());
                log.debug("Using customized endpoint url: {}", customizedEndpointUrl);
            }
            ClientHttpRequest httpRequest = this.clientHttpRequestFactory.createRequest(new URI((String)customizedEndpointUrl), method);
            Set<Header> headers = new HashSet<Header>();
            if (request.getHeaders() != null) {
                headers.addAll(request.getHeaders());
            }
            if (testResult.getOperationsHeaders() != null) {
                if (testResult.getOperationsHeaders().getGlobals() != null) {
                    headers.addAll(testResult.getOperationsHeaders().getGlobals());
                }
                if (testResult.getOperationsHeaders().get((Object)operation.getName()) != null) {
                    headers.addAll((Collection)testResult.getOperationsHeaders().get((Object)operation.getName()));
                }
            }
            if (!headers.isEmpty()) {
                for (Header header : headers) {
                    log.debug("Adding header {} to request", (Object)header.getName());
                    httpRequest.getHeaders().add(header.getName(), this.buildValue(header.getValues()));
                }
                request.setHeaders(headers);
            }
            if (this.secret != null) {
                this.addAuthorizationHeadersFromSecret(httpRequest, request, this.secret);
            }
            this.prepareRequest(request);
            if (request.getContent() != null) {
                request.setContent(TestRunnerCommons.renderRequestContent(request, headers));
                log.trace("Sending following request content: {}", (Object)request.getContent());
                httpRequest.getBody().write(request.getContent().getBytes());
            }
            long startTime = System.currentTimeMillis();
            ClientHttpResponse httpResponse = null;
            try {
                httpResponse = httpRequest.execute();
            }
            catch (IOException ioe) {
                log.error("IOException while executing request {} on {}", new Object[]{request.getName(), customizedEndpointUrl, ioe});
                code = 1;
                message = ioe.getMessage();
            }
            long duration = System.currentTimeMillis() - startTime;
            String responseContent = null;
            if (httpResponse != null) {
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)httpResponse.getBody(), (Writer)writer);
                responseContent = writer.toString();
            }
            if (code == 0) {
                code = this.extractTestReturnCode(service, operation, request, httpResponse, responseContent);
                message = this.extractTestReturnMessage(service, operation, request, httpResponse);
            }
            Response response = new Response();
            if (httpResponse != null) {
                response.setContent(responseContent);
                response.setStatus(String.valueOf(httpResponse.getStatusCode().value()));
                log.debug("Response Content-Type: {}", (Object)httpResponse.getHeaders().getContentType());
                if (httpResponse.getHeaders().getContentType() != null) {
                    response.setMediaType(httpResponse.getHeaders().getContentType().toString());
                }
                if ((headers = this.buildHeaders(httpResponse)) != null) {
                    response.setHeaders(headers);
                }
                log.info("Closing http response");
                httpResponse.close();
            }
            result.add(new TestReturn(code, duration, message, request, response));
        }
        return result;
    }

    @Override
    public HttpMethod buildMethod(String method) {
        if (method != null) {
            if ("GET".equals(method.toUpperCase().trim())) {
                return HttpMethod.GET;
            }
            if ("PUT".equals(method.toUpperCase().trim())) {
                return HttpMethod.PUT;
            }
            if ("DELETE".equals(method.toUpperCase().trim())) {
                return HttpMethod.DELETE;
            }
            if ("PATCH".equals(method.toUpperCase().trim())) {
                return HttpMethod.PATCH;
            }
            if ("OPTIONS".equals(method.toUpperCase().trim())) {
                return HttpMethod.OPTIONS;
            }
        }
        return HttpMethod.POST;
    }

    protected int extractTestReturnCode(Service service, Operation operation, Request request, ClientHttpResponse httpResponse, String responseContent) {
        int code = 0;
        try {
            if (httpResponse.getStatusCode().value() > 299) {
                log.debug("Http status code is {}, marking test as failed.", (Object)httpResponse.getStatusCode().value());
                code = 1;
            }
        }
        catch (IOException ioe) {
            log.debug("IOException while getting raw status code in response", (Throwable)ioe);
            code = 1;
        }
        return code;
    }

    protected void prepareRequest(Request request) {
    }

    protected String extractTestReturnMessage(Service service, Operation operation, Request request, ClientHttpResponse httpResponse) {
        String message = null;
        try {
            message = String.valueOf(httpResponse.getStatusCode().value());
        }
        catch (IOException ioe) {
            log.debug("IOException while getting raw status code in response", (Throwable)ioe);
            message = "IOException while getting raw status code in response";
        }
        return message;
    }

    private Set<Header> buildHeaders(ClientHttpResponse httpResponse) {
        if (httpResponse.getHeaders() != null && !httpResponse.getHeaders().isEmpty()) {
            HashSet<Header> headers = new HashSet<Header>();
            HttpHeaders responseHeaders = httpResponse.getHeaders();
            for (Map.Entry responseHeader : responseHeaders.entrySet()) {
                Header header = new Header();
                header.setName((String)responseHeader.getKey());
                header.setValues(new HashSet((Collection)responseHeader.getValue()));
                headers.add(header);
            }
            return headers;
        }
        return null;
    }

    private void addAuthorizationHeadersFromSecret(ClientHttpRequest httpRequest, Request request, Secret secret) {
        if (secret != null) {
            if (secret.getUsername() != null && secret.getPassword() != null) {
                log.debug("Secret contains username/password, assuming Authorization Basic");
                String encoded = Base64.getEncoder().encodeToString((secret.getUsername() + ":" + secret.getPassword()).getBytes(StandardCharsets.UTF_8));
                httpRequest.getHeaders().set("Authorization", "Basic " + encoded);
                request.getHeaders().add(this.buildAuthHeaderWithSecret("Authorization", "Basic "));
            }
            if (secret.getToken() != null) {
                if (secret.getTokenHeader() != null && secret.getTokenHeader().trim().length() > 0) {
                    log.debug("Secret contains token and token header, adding them as request header");
                    httpRequest.getHeaders().set(secret.getTokenHeader().trim(), secret.getToken());
                    request.getHeaders().add(this.buildAuthHeaderWithSecret(secret.getTokenHeader().trim(), ""));
                } else {
                    log.debug("Secret contains token only, assuming Authorization Bearer");
                    httpRequest.getHeaders().set("Authorization", "Bearer " + secret.getToken());
                    request.getHeaders().add(this.buildAuthHeaderWithSecret("Authorization", "Bearer "));
                }
            }
        }
    }

    private Header buildAuthHeaderWithSecret(String name, String type) {
        Header authHeader = new Header();
        authHeader.setName(name);
        authHeader.setValues(new TreeSet<String>(Arrays.asList(type + "<value-from-secret>")));
        return authHeader;
    }
}

