/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.soapui.assertions;

import io.github.microcks.util.soapui.assertions.AssertionStatus;
import io.github.microcks.util.soapui.assertions.ExchangeContext;
import io.github.microcks.util.soapui.assertions.RequestResponseExchange;
import io.github.microcks.util.soapui.assertions.SoapUIAssertion;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapFaultAssertion
implements SoapUIAssertion {
    private static Logger log = LoggerFactory.getLogger(SoapFaultAssertion.class);
    private String errorMessage;

    @Override
    public void configure(Map<String, String> configParams) {
    }

    @Override
    public AssertionStatus assertResponse(RequestResponseExchange exchange, ExchangeContext context) {
        log.debug("Asserting response is a SOAP Fault");
        String responseContent = exchange.responseContent();
        if (!responseContent.contains(":Fault") && !responseContent.contains("<Fault")) {
            this.errorMessage = "Response is not a SOAP Fault";
            return AssertionStatus.FAILED;
        }
        return AssertionStatus.VALID;
    }

    @Override
    public List<String> getErrorMessages() {
        return List.of(this.errorMessage);
    }
}

