/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.postman;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.microcks.util.postman.PostmanCollectionImporter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostmanWorkspaceCollectionImporter
extends PostmanCollectionImporter {
    private static Logger log = LoggerFactory.getLogger(PostmanWorkspaceCollectionImporter.class);
    private static final String COLLECTION_WRAPPER_PROPERTY = "collection";

    public PostmanWorkspaceCollectionImporter(String collectionFilePath) throws IOException {
        try {
            byte[] jsonBytes = Files.readAllBytes(Paths.get(collectionFilePath, new String[0]));
            this.setCollectionContent(new String(jsonBytes, StandardCharsets.UTF_8));
            ObjectMapper mapper = new ObjectMapper();
            JsonNode collectionWrapper = mapper.readTree(jsonBytes);
            this.setCollection(collectionWrapper.path(COLLECTION_WRAPPER_PROPERTY));
        }
        catch (Exception e) {
            log.error("Exception while parsing Postman workspace collection file " + collectionFilePath, (Throwable)e);
            throw new IOException("Postman workspace collection file parsing error");
        }
    }
}

