/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.security;

import io.github.microcks.security.EnableUserInfoInContext;
import io.github.microcks.security.KeycloakTokenToUserInfoMapper;
import io.github.microcks.security.UserInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class UserInfoInContextInterceptor
implements HandlerInterceptor {
    private static Logger log = LoggerFactory.getLogger(UserInfoInContextInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        log.trace("Intercepting and pre-handling request to check @EnableUserInfoInContext");
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            EnableUserInfoInContext needUserInfo = (EnableUserInfoInContext)handlerMethod.getMethodAnnotation(EnableUserInfoInContext.class);
            if (needUserInfo == null) {
                needUserInfo = handlerMethod.getMethod().getDeclaringClass().getAnnotation(EnableUserInfoInContext.class);
            }
            if (needUserInfo == null) {
                return true;
            }
            log.debug("@EnableUserInfoInContext is present on {}", handler);
            SecurityContext securityContext = SecurityContextHolder.getContext();
            if (securityContext.getAuthentication() != null) {
                log.debug("Found a Spring Security Authentication to map to UserInfo");
                UserInfo userInfo = KeycloakTokenToUserInfoMapper.map(securityContext);
                request.setAttribute(UserInfo.class.getName(), (Object)userInfo);
            }
        }
        return super.preHandle(request, response, handler);
    }
}

