/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.ImportJob;
import io.github.microcks.domain.Metadata;
import io.github.microcks.repository.ImportJobRepository;
import io.github.microcks.security.AuthorizationChecker;
import io.github.microcks.security.UserInfo;
import io.github.microcks.service.JobService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class JobController {
    private static Logger log = LoggerFactory.getLogger(JobController.class);
    @Autowired
    private ImportJobRepository jobRepository;
    @Autowired
    private JobService jobService;
    @Autowired
    private AuthorizationChecker authorizationChecker;

    @RequestMapping(value={"/jobs"}, method={RequestMethod.GET})
    public List<ImportJob> listJobs(@RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="size", required=false, defaultValue="20") int size, @RequestParam(value="name", required=false) String name) {
        log.debug("Getting job list for page {} and size {}", (Object)page, (Object)size);
        if (name != null) {
            return this.jobRepository.findByNameLike(name);
        }
        return this.jobRepository.findAll((Pageable)PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"name"}))).getContent();
    }

    @RequestMapping(value={"/jobs/search"}, method={RequestMethod.GET})
    public List<ImportJob> searchJobs(@RequestParam Map<String, String> queryMap) {
        String name = null;
        HashMap<String, String> labels = new HashMap<String, String>();
        for (String paramKey : queryMap.keySet()) {
            if ("name".equals(paramKey)) {
                name = queryMap.get("name");
            }
            if (!paramKey.startsWith("labels.")) continue;
            labels.put(paramKey.substring(paramKey.indexOf(46) + 1), queryMap.get(paramKey));
        }
        if (labels == null || labels.isEmpty()) {
            log.debug("Searching jobs corresponding to name {}", name);
            return this.jobRepository.findByNameLike(name);
        }
        if (name == null || name.trim().length() == 0) {
            log.debug("Searching jobs corresponding to labels {}", labels);
            return this.jobRepository.findByLabels(labels);
        }
        log.debug("Searching jobs corresponding to name {} and labels {}", (Object)name, labels);
        return this.jobRepository.findByLabelsAndNameLike(labels, name);
    }

    @RequestMapping(value={"/jobs/count"}, method={RequestMethod.GET})
    public Map<String, Long> countJobs() {
        log.debug("Counting jobs...");
        HashMap<String, Long> counter = new HashMap<String, Long>();
        counter.put("counter", this.jobRepository.count());
        return counter;
    }

    @RequestMapping(value={"/jobs"}, method={RequestMethod.POST})
    public ResponseEntity<ImportJob> createJob(@RequestBody ImportJob job) {
        log.debug("Creating new job: {}", (Object)job);
        Map labels = null;
        if (job.getMetadata() != null && job.getMetadata().getLabels() != null) {
            labels = job.getMetadata().getLabels();
        }
        job.setMetadata(new Metadata());
        job.setCreatedDate(new Date());
        if (labels != null) {
            job.getMetadata().setLabels(labels);
        }
        return new ResponseEntity((Object)((ImportJob)this.jobRepository.save(job)), HttpStatus.CREATED);
    }

    @RequestMapping(value={"/jobs/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<ImportJob> getJob(@PathVariable(value="id") String jobId) {
        log.debug("Retrieving job with id {}", (Object)jobId);
        return new ResponseEntity((Object)this.jobRepository.findById(jobId).orElse(null), HttpStatus.OK);
    }

    @RequestMapping(value={"/jobs/{id}"}, method={RequestMethod.POST})
    public ResponseEntity<ImportJob> saveJob(@RequestBody ImportJob job, UserInfo userInfo) {
        log.debug("Saving existing job: {}", (Object)job);
        if (this.authorizationChecker.hasRole(userInfo, "admin") || this.authorizationChecker.hasRoleForImportJob(userInfo, "manager", job)) {
            this.initMetadataIfMissing(job);
            job.getMetadata().objectUpdated();
            return new ResponseEntity((Object)((ImportJob)this.jobRepository.save(job)), HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.FORBIDDEN);
    }

    @RequestMapping(value={"/jobs/{id}/activate"}, method={RequestMethod.PUT})
    public ResponseEntity<ImportJob> activateJob(@PathVariable(value="id") String jobId, UserInfo userInfo) {
        log.debug("Activating job with id {}", (Object)jobId);
        ImportJob job = this.jobRepository.findById(jobId).orElse(null);
        if (this.authorizationChecker.hasRole(userInfo, "admin") || this.authorizationChecker.hasRoleForImportJob(userInfo, "manager", job)) {
            job.setActive(true);
            this.initMetadataIfMissing(job);
            job.getMetadata().objectUpdated();
            return new ResponseEntity((Object)((ImportJob)this.jobRepository.save(job)), HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.FORBIDDEN);
    }

    @RequestMapping(value={"/jobs/{id}/start"}, method={RequestMethod.PUT})
    public ResponseEntity<ImportJob> startJob(@PathVariable(value="id") String jobId, UserInfo userInfo) {
        log.debug("Starting job with id {}", (Object)jobId);
        ImportJob job = this.jobRepository.findById(jobId).orElse(null);
        if (this.authorizationChecker.hasRole(userInfo, "admin") || this.authorizationChecker.hasRoleForImportJob(userInfo, "manager", job)) {
            job.setActive(true);
            this.initMetadataIfMissing(job);
            job.getMetadata().objectUpdated();
            this.jobService.doImportJob(job);
            return new ResponseEntity((Object)job, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.FORBIDDEN);
    }

    @RequestMapping(value={"/jobs/{id}/stop"}, method={RequestMethod.PUT})
    public ResponseEntity<ImportJob> stopJob(@PathVariable(value="id") String jobId, UserInfo userInfo) {
        log.debug("Stopping job with id {}", (Object)jobId);
        ImportJob job = this.jobRepository.findById(jobId).orElse(null);
        if (this.authorizationChecker.hasRole(userInfo, "admin") || this.authorizationChecker.hasRoleForImportJob(userInfo, "manager", job)) {
            job.setActive(false);
            this.initMetadataIfMissing(job);
            job.getMetadata().objectUpdated();
            return new ResponseEntity((Object)((ImportJob)this.jobRepository.save(job)), HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.FORBIDDEN);
    }

    @RequestMapping(value={"/jobs/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> deleteJob(@PathVariable(value="id") String jobId, UserInfo userInfo) {
        log.debug("Removing job with id {}", (Object)jobId);
        ImportJob job = this.jobRepository.findById(jobId).orElse(null);
        if (this.authorizationChecker.hasRole(userInfo, "admin") || this.authorizationChecker.hasRoleForImportJob(userInfo, "manager", job)) {
            this.jobRepository.deleteById(jobId);
            return new ResponseEntity(HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.FORBIDDEN);
    }

    private void initMetadataIfMissing(ImportJob job) {
        if (job.getMetadata() == null) {
            job.setMetadata(new Metadata());
        }
    }
}

