/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToStringsMap
extends HashMap<String, List<String>> {
    private static Logger log = LoggerFactory.getLogger(StringToStringsMap.class);
    private boolean equalsOnThis;

    public List<String> get(String key, List<String> defaultValue) {
        List value = (List)this.get(key);
        return value == null ? defaultValue : value;
    }

    public boolean hasValues(String key) {
        return this.containsKey(key) && ((List)this.get(key)).size() > 0;
    }

    public void add(String key, boolean value) {
        this.add(key, Boolean.toString(value));
    }

    public void add(String key, String string) {
        if (!this.containsKey(key)) {
            this.put(key, new ArrayList());
        }
        ((List)this.get(key)).add(string);
    }

    public static StringToStringsMap fromHttpHeader(String value) {
        StringToStringsMap result = new StringToStringsMap();
        int ix = value.indexOf(59);
        while (ix > 0) {
            StringToStringsMap.extractNVPair(value.substring(0, ix), result);
            value = value.substring(ix + 1);
            ix = value.indexOf(59);
        }
        if (value.length() > 2) {
            StringToStringsMap.extractNVPair(value, result);
        }
        return result;
    }

    private static void extractNVPair(String value, StringToStringsMap result) {
        int ix = value.indexOf(61);
        if (ix != -1) {
            String str = value.substring(ix + 1).trim();
            if (str.startsWith("\"") && str.endsWith("\"")) {
                str = str.substring(1, str.length() - 1);
            }
            result.add(value.substring(0, ix).trim(), str);
        }
    }

    public void setEqualsOnThis(boolean equalsOnThis) {
        this.equalsOnThis = equalsOnThis;
    }

    @Override
    public boolean equals(Object o) {
        return this.equalsOnThis ? this == o : super.equals(o);
    }

    public String[] getKeys() {
        return this.keySet().toArray(new String[this.size()]);
    }

    public boolean containsKeyIgnoreCase(String string) {
        String key;
        Iterator var2 = this.keySet().iterator();
        do {
            if (var2.hasNext()) continue;
            return false;
        } while (!(key = (String)var2.next()).equalsIgnoreCase(string));
        return true;
    }

    @Override
    public void put(String name, String value) {
        this.add(name, value);
    }

    public String get(String key, String defaultValue) {
        List value = (List)this.get(key);
        return value != null && value.size() != 0 ? (String)value.get(0) : defaultValue;
    }

    public String getCaseInsensitive(String key, String defaultValue) {
        Map.Entry stringListEntry;
        Iterator var3 = this.entrySet().iterator();
        do {
            if (var3.hasNext()) continue;
            return defaultValue;
        } while (!key.equalsIgnoreCase((String)(stringListEntry = var3.next()).getKey()) || ((List)stringListEntry.getValue()).isEmpty());
        return (String)((List)stringListEntry.getValue()).get(0);
    }

    public void replace(String key, String oldValue, String value) {
        int ix;
        List values = (List)this.get(key);
        if (values != null && (ix = values.indexOf(oldValue)) >= 0) {
            values.set(ix, value);
        }
    }

    public void remove(String key, String data) {
        List values = (List)this.get(key);
        if (values != null) {
            values.remove(data);
        }
    }

    public int valueCount() {
        int result = 0;
        for (String key : this.keySet()) {
            result += ((List)this.get(key)).size();
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        for (String key : this.keySet()) {
            for (String value : (List)this.get(key)) {
                result.append(key).append(" : ").append(value).append("\r\n");
            }
        }
        return result.toString();
    }
}

