/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.github.microcks.domain.Service;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class ResourceUtil {
    private static Logger log = LoggerFactory.getLogger(ResourceUtil.class);
    private static final String SERVICE_PATTERN = "\\{service\\}";
    private static final String VERSION_PATTERN = "\\{version\\}";
    private static final String RESOURCE_PATTERN = "\\{resource\\}";
    private static final String SCHEMA_PATTERN = "\\{resourceSchema\\}";
    private static final String REFERENCE_PATTERN = "\\{reference\\}";

    public static InputStream getClasspathResource(String resourcePath) throws IOException {
        ClassPathResource template = new ClassPathResource(resourcePath);
        return template.getInputStream();
    }

    public static String replaceTemplatesInSpecStream(InputStream stream, Service service, String resource, JsonNode referenceSchema, String referencePayload) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringWriter writer = new StringWriter();
        try (Stream<String> lines = reader.lines();){
            lines.map(line -> ResourceUtil.replaceInLine(line, service, resource, referenceSchema, referencePayload)).forEach(line -> writer.write(line + "\n"));
        }
        return writer.toString();
    }

    private static String replaceInLine(String line, Service service, String resource, JsonNode referenceSchema, String referencePayload) {
        line = line.replaceAll(SERVICE_PATTERN, service.getName());
        line = line.replaceAll(VERSION_PATTERN, service.getVersion());
        if ((line = line.replaceAll(RESOURCE_PATTERN, resource)).matches(".*\\{resourceSchema\\}.*")) {
            if (referenceSchema != null) {
                try {
                    ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).disable(YAMLGenerator.Feature.INDENT_ARRAYS));
                    String schema = mapper.writeValueAsString((Object)referenceSchema);
                    log.debug("schema: " + schema);
                    line = line.replaceAll(SCHEMA_PATTERN, schema.replaceAll("\\n", "\n      "));
                }
                catch (Exception e) {
                    log.warn("Exception while replacing resource schema", (Throwable)e);
                }
            } else {
                line = line.replaceAll(SCHEMA_PATTERN, "");
            }
        }
        if (line.matches(".*\\{reference\\}.*")) {
            line = referencePayload != null ? line.replaceAll(REFERENCE_PATTERN, referencePayload.replaceAll("\\n", "")) : line.replaceAll(REFERENCE_PATTERN, "");
        }
        return line;
    }
}

