/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import io.github.microcks.util.SimpleReferenceURLBuilder;
import java.util.List;
import java.util.Map;

public class GitLabReferenceURLBuilder
extends SimpleReferenceURLBuilder {
    public static final String GITLAB_FILE_NAME_HEADER = "X-Gitlab-File-Name";
    private static final String REPOSITORY_FILES_MARKER = "/repository/files/";
    private static final String ENCODED_FILE_SEPARATOR = "%2F";

    @Override
    public String getFileName(String baseRepositoryURL, Map<String, List<String>> headers) {
        if (headers != null && headers.containsKey(GITLAB_FILE_NAME_HEADER)) {
            return headers.get(GITLAB_FILE_NAME_HEADER).get(0);
        }
        String lastPath = baseRepositoryURL.substring(baseRepositoryURL.lastIndexOf("/") + 1);
        if (lastPath.startsWith("raw?ref=") || lastPath.indexOf(46) == -1) {
            String[] pathElements = baseRepositoryURL.split("/");
            for (int i = pathElements.length; i > 0; --i) {
                String path = pathElements[i - 1];
                if (!path.contains(".") || !path.contains(ENCODED_FILE_SEPARATOR)) continue;
                return path.substring(path.indexOf(ENCODED_FILE_SEPARATOR) + ENCODED_FILE_SEPARATOR.length());
            }
        }
        return null;
    }

    @Override
    public String buildRemoteURL(String baseRepositoryURL, String referencePath) {
        String rootURL = baseRepositoryURL.substring(0, baseRepositoryURL.indexOf(REPOSITORY_FILES_MARKER) + REPOSITORY_FILES_MARKER.length() - 1);
        String basePath = baseRepositoryURL.substring(baseRepositoryURL.indexOf(REPOSITORY_FILES_MARKER) + REPOSITORY_FILES_MARKER.length(), baseRepositoryURL.lastIndexOf("/"));
        String formatOptions = baseRepositoryURL.substring(baseRepositoryURL.lastIndexOf("/") + 1);
        String pathFragment = super.buildRemoteURL("/" + basePath.replaceAll(ENCODED_FILE_SEPARATOR, "/"), referencePath);
        return rootURL + "/" + pathFragment.substring(1).replaceAll("/", ENCODED_FILE_SEPARATOR) + "/" + formatOptions;
    }
}

