/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.listener;

import io.github.microcks.domain.Operation;
import io.github.microcks.domain.RequestResponsePair;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.domain.ServiceView;
import io.github.microcks.domain.UnidirectionalEvent;
import io.github.microcks.event.ChangeType;
import io.github.microcks.event.ServiceChangeEvent;
import io.github.microcks.event.ServiceViewChangeEvent;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.service.MessageService;
import io.github.microcks.util.IdBuilder;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationListener;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"async-api.enabled"}, havingValue="true", matchIfMissing=true)
public class ServiceChangeEventPublisher
implements ApplicationListener<ServiceChangeEvent> {
    private static Log log = LogFactory.getLog(ServiceChangeEventPublisher.class);
    @Autowired
    private ServiceRepository serviceRepository;
    @Autowired
    private MessageService messageService;
    @Autowired
    private KafkaTemplate<String, ServiceViewChangeEvent> kafkaTemplate;

    @Async
    public void onApplicationEvent(ServiceChangeEvent event) {
        Service service;
        log.debug((Object)("Received a ServiceChangeEvent on " + event.getServiceId()));
        ServiceView serviceView = null;
        if (event.getChangeType() != ChangeType.DELETED && (service = (Service)this.serviceRepository.findById(event.getServiceId()).orElse(null)) != null) {
            HashMap<String, List<Object>> messagesMap = new HashMap<String, List<Object>>();
            for (Operation operation : service.getOperations()) {
                if (service.getType() == ServiceType.EVENT || service.getType() == ServiceType.GENERIC_EVENT) {
                    List<UnidirectionalEvent> events = this.messageService.getEventByOperation(IdBuilder.buildOperationId((Service)service, (Operation)operation));
                    messagesMap.put(operation.getName(), events);
                    continue;
                }
                List<RequestResponsePair> pairs = this.messageService.getRequestResponseByOperation(IdBuilder.buildOperationId((Service)service, (Operation)operation));
                messagesMap.put(operation.getName(), pairs);
            }
            serviceView = new ServiceView(service, messagesMap);
        }
        ServiceViewChangeEvent serviceViewChangeEvent = new ServiceViewChangeEvent(event.getServiceId(), serviceView, event.getChangeType(), System.currentTimeMillis());
        this.kafkaTemplate.send("microcks-services-updates", (Object)event.getServiceId(), (Object)serviceViewChangeEvent);
        log.debug((Object)"Processing of ServiceChangeEvent done !");
    }
}

