/*
 * Decompiled with CFR 0.152.
 */
package io.github.marceltanuri.commons.oauthclient.internal;

import io.github.marceltanuri.commons.oauthclient.internal.TokenResponse;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class OAuth2TokenCache {
    private static final int DEFAULT_MAX_ENTRIES = 100;
    private final Map<String, TokenResponse> _cache;

    private OAuth2TokenCache(final int maxEntries) {
        this._cache = Collections.synchronizedMap(new LinkedHashMap<String, TokenResponse>(maxEntries, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, TokenResponse> eldest) {
                return this.size() > maxEntries;
            }
        });
    }

    public static OAuth2TokenCache ofDefault() {
        return new OAuth2TokenCache(100);
    }

    public static OAuth2TokenCache of(int maxEntries) {
        return new OAuth2TokenCache(maxEntries);
    }

    public TokenResponse get(String key) {
        TokenResponse token = this._cache.get(key);
        if (token != null && token.isValid()) {
            return token;
        }
        return null;
    }

    public void put(String key, TokenResponse token) {
        this._cache.put(key, token);
    }
}

