/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.server.model.federation.edu.content.nested;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Map;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="Device keys.")
public class DeviceKeys {
    @Schema(name="user_id", description="The ID of the user the device belongs to. Must match the user ID used when logging in.", required=true)
    @JsonbProperty(value="user_id")
    private String userId;
    @Schema(name="device_id", description="The ID of the device these keys belong to. Must match the device ID used when logging in.", required=true)
    @JsonbProperty(value="device_id")
    private String deviceId;
    @Schema(description="The encryption algorithms supported by this device.", required=true)
    private List<String> algorithms;
    @Schema(description="Public identity keys. The names of the properties should be in the format <algorithm>:<device_id>. The keys themselves should be encoded as specified by the key algorithm.", required=true)
    private Map<String, String> keys;
    @Schema(description="Required. Signatures for the device key object. A map from user ID, to a map from <algorithm>:<device_id> to the signature. The signature is calculated using the process described at Signing JS", required=true)
    private Map<String, Map<String, String>> signatures;

    @JsonProperty(value="user_id")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public List<String> getAlgorithms() {
        return this.algorithms;
    }

    public void setAlgorithms(List<String> algorithms) {
        this.algorithms = algorithms;
    }

    public Map<String, String> getKeys() {
        return this.keys;
    }

    public void setKeys(Map<String, String> keys) {
        this.keys = keys;
    }

    public Map<String, Map<String, String>> getSignatures() {
        return this.signatures;
    }

    public void setSignatures(Map<String, Map<String, String>> signatures) {
        this.signatures = signatures;
    }
}

