/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.push.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.Id;
import io.github.ma1uta.matrix.event.content.EventContent;
import io.github.ma1uta.matrix.push.model.Counts;
import io.github.ma1uta.matrix.push.model.Device;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="Information about the push notification.")
public class Notification {
    @Schema(name="event_id", description="The Matrix event ID of the event being notified about. This is required if the notification is about a particular Matrix event. It may be omitted for notifications that only contain updated badge counts. This ID can and should be used to detect duplicate notification requests.")
    @JsonbProperty(value="event_id")
    private Id eventId;
    @Schema(name="room_id", description="The ID of the room in which this event occurred. Required if the notification relates to a specific Matrix event.")
    @JsonbProperty(value="room_id")
    private Id roomId;
    @Schema(description="The type of the event as in the event's type field.")
    private String type;
    @Schema(description="The sender of the event as in the corresponding event field.")
    private Id sender;
    @Schema(name="sender_display_name", description="The current display name of the sender in the room in which the event occurred.")
    @JsonbProperty(value="sender_display_name")
    private String senderDisplayName;
    @Schema(name="room_name", description="The name of the room in which the event occurred.")
    @JsonbProperty(value="room_name")
    private String roomName;
    @Schema(name="room_alias", description="An alias to display for the room in which the event occurred.")
    @JsonbProperty(value="room_alias")
    private Id roomAlias;
    @Schema(name="user_is_target", description="This is true if the user receiving the notification is the subject of a member event (i.e. the state_key of the member event is equal to the user's Matrix ID).")
    @JsonbProperty(value="user_is_target")
    private Boolean userIsTarget;
    @Schema(description="The priority of the notification. If omitted, high is assumed. This may be used by push gateways to deliverless time-sensitive notifications in a way that will preserve battery power on mobile devices.", allowableValues={"high, low"})
    private String prio;
    @Schema(description="The content field from the event, if present. If the event had no content field, this field is omitted.")
    private EventContent content;
    @Schema(description="This is a dictionary of the current number of unacknowledged communications for the recipient user. Counts whose value is zero should be omitted.")
    private Counts counts;
    @Schema(description="This is an array of devices that the notification should be sent to.", required=true)
    private List<Device> devices;

    @JsonProperty(value="event_id")
    public Id getEventId() {
        return this.eventId;
    }

    public void setEventId(Id eventId) {
        this.eventId = eventId;
    }

    @JsonProperty(value="room_id")
    public Id getRoomId() {
        return this.roomId;
    }

    public void setRoomId(Id roomId) {
        this.roomId = roomId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Id getSender() {
        return this.sender;
    }

    public void setSender(Id sender) {
        this.sender = sender;
    }

    @JsonProperty(value="sender_display_name")
    public String getSenderDisplayName() {
        return this.senderDisplayName;
    }

    public void setSenderDisplayName(String senderDisplayName) {
        this.senderDisplayName = senderDisplayName;
    }

    @JsonProperty(value="room_name")
    public String getRoomName() {
        return this.roomName;
    }

    public void setRoomName(String roomName) {
        this.roomName = roomName;
    }

    @JsonProperty(value="room_alias")
    public Id getRoomAlias() {
        return this.roomAlias;
    }

    public void setRoomAlias(Id roomAlias) {
        this.roomAlias = roomAlias;
    }

    @JsonProperty(value="user_is_target")
    public Boolean getUserIsTarget() {
        return this.userIsTarget;
    }

    public void setUserIsTarget(Boolean userIsTarget) {
        this.userIsTarget = userIsTarget;
    }

    public String getPrio() {
        return this.prio;
    }

    public void setPrio(String prio) {
        this.prio = prio;
    }

    public EventContent getContent() {
        return this.content;
    }

    public void setContent(EventContent content) {
        this.content = content;
    }

    public Counts getCounts() {
        return this.counts;
    }

    public void setCounts(Counts counts) {
        this.counts = counts;
    }

    public List<Device> getDevices() {
        return this.devices;
    }

    public void setDevices(List<Device> devices) {
        this.devices = devices;
    }

    public static class Priority {
        public static final String HIGH = "high";
        public static final String LOW = "low";

        protected Priority() {
        }
    }
}

