/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.push.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.EventContent;
import io.github.ma1uta.matrix.push.model.Counts;
import io.github.ma1uta.matrix.push.model.Device;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@ApiModel(description="Information about the push notification.")
public class Notification {
    @ApiModelProperty(name="event_id", value="The Matrix event ID of the event being notified about. This is required if the notification is about a particular Matrix event. It may be omitted for notifications that only contain updated badge counts. This ID can and should be used to detect duplicate notification requests.")
    @JsonProperty(value="event_id")
    private String eventId;
    @ApiModelProperty(name="room_id", value="The ID of the room in which this event occurred. Required if the notification relates to a specific Matrix event.")
    @JsonProperty(value="room_id")
    private String roomId;
    @ApiModelProperty(value="The type of the event as in the event's type field.")
    private String type;
    @ApiModelProperty(value="The sender of the event as in the corresponding event field.")
    private String sender;
    @ApiModelProperty(name="sender_display_name", value="The current display name of the sender in the room in which the event occurred.")
    @JsonProperty(value="sender_display_name")
    private String senderDisplayName;
    @ApiModelProperty(name="room_name", value="The name of the room in which the event occurred.")
    @JsonProperty(value="room_name")
    private String roomName;
    @ApiModelProperty(name="room_alias", value="An alias to display for the room in which the event occurred.")
    @JsonProperty(value="room_alias")
    private String roomAlias;
    @ApiModelProperty(name="user_is_target", value="This is true if the user receiving the notification is the subject of a member event (i.e. the state_key of the member event is equal to the user's Matrix ID).")
    @JsonProperty(value="user_is_target")
    private Boolean userIsTarget;
    @ApiModelProperty(value="The priority of the notification. If omitted, high is assumed. This may be used by push gateways to deliverless time-sensitive notifications in a way that will preserve battery power on mobile devices.", allowableValues="high, low")
    private String prio;
    @ApiModelProperty(value="The content field from the event, if present. The pusher may omit this if the event had no content or for any other reas")
    private EventContent content;
    @ApiModelProperty(value="This is a dictionary of the current number of unacknowledged communications for the recipient user. Counts whose value is zero should be omitted.")
    private Counts counts;
    @ApiModelProperty(value="This is an array of devices that the notification should be sent to.", required=true)
    private List<Device> devices;

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getSenderDisplayName() {
        return this.senderDisplayName;
    }

    public void setSenderDisplayName(String senderDisplayName) {
        this.senderDisplayName = senderDisplayName;
    }

    public String getRoomName() {
        return this.roomName;
    }

    public void setRoomName(String roomName) {
        this.roomName = roomName;
    }

    public String getRoomAlias() {
        return this.roomAlias;
    }

    public void setRoomAlias(String roomAlias) {
        this.roomAlias = roomAlias;
    }

    public Boolean getUserIsTarget() {
        return this.userIsTarget;
    }

    public void setUserIsTarget(Boolean userIsTarget) {
        this.userIsTarget = userIsTarget;
    }

    public String getPrio() {
        return this.prio;
    }

    public void setPrio(String prio) {
        this.prio = prio;
    }

    public EventContent getContent() {
        return this.content;
    }

    public void setContent(EventContent content) {
        this.content = content;
    }

    public Counts getCounts() {
        return this.counts;
    }

    public void setCounts(Counts counts) {
        this.counts = counts;
    }

    public List<Device> getDevices() {
        return this.devices;
    }

    public void setDevices(List<Device> devices) {
        this.devices = devices;
    }

    public static class Priority {
        public static final String HIGH = "high";
        public static final String LOW = "low";

        protected Priority() {
        }
    }
}

