/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.push.api;

import io.github.ma1uta.matrix.push.model.Notification;
import io.github.ma1uta.matrix.push.model.RejectedPushKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;

@Api(value="Push", description="This describes the format used by \"HTTP\" pushers to send notifications of events to Push Gateways. If the endpoint returns an HTTP error code, the homeserver SHOULD retry for a reasonable amount of time using exponential backoff.")
@Path(value="/_matrix/push/r0")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface PushApi {
    @ApiOperation(value="This endpoint is invoked by HTTP pushers to notify a push gateway about an event or update the number of unread notifications a user has.", notes="In the former case it will contain selected information about the event. In either case it may contain numeric counts of the number of unread events of different types the user has. The counts may be sent along with a notification about an event or by themselves.\nNotifications about a particular event will normally cause the user to be alerted in some way.It is therefore necessary to perform duplicate suppression for such notifications using the event_id field to avoid retries of this HTTP API causing duplicate alerts.The operation of updating counts of unread notifications should be idempotent and therefore do not require duplicate suppression.\nNotifications are sent to the URL configured when the pusher is created.This means that the HTTP path may be different depending on the push gateway.", response=RejectedPushKey.class)
    @ApiResponses(value={@ApiResponse(code=200, message="A list of rejected push keys.")})
    @POST
    @Path(value="/notify")
    public void pushNotify(@ApiParam(value="Information about the push notification.", required=true) Notification var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);
}

