/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.push.api;

import io.github.ma1uta.matrix.push.model.Notification;
import io.github.ma1uta.matrix.push.model.RejectedPushKey;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/push/v1")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface PushApi {
    @Operation(summary="This endpoint is invoked by HTTP pushers to notify a push gateway about an event or update the number of unread notifications a user has.", description="In the former case it will contain selected information about the event. In either case it may contain numeric counts of the number of unread events of different types the user has. The counts may be sent along with a notification about an event or by themselves.\nNotifications about a particular event will normally cause the user to be alerted in some way.It is therefore necessary to perform duplicate suppression for such notifications using the event_id field to avoid retries of this HTTP API causing duplicate alerts.The operation of updating counts of unread notifications should be idempotent and therefore do not require duplicate suppression.\nNotifications are sent to the URL configured when the pusher is created.This means that the HTTP path may be different depending on the push gateway.", responses={@ApiResponse(responseCode="200", description="A list of rejected push keys.", content={@Content(schema=@Schema(implementation=RejectedPushKey.class))})})
    @POST
    @Path(value="/notify")
    public void pushNotify(@RequestBody(description="Information about the push notification.", required=true) Notification var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);
}

