/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.support.jsonb;

import io.github.ma1uta.matrix.event.content.RoomMessageContent;
import io.github.ma1uta.matrix.event.message.Audio;
import io.github.ma1uta.matrix.event.message.Emote;
import io.github.ma1uta.matrix.event.message.File;
import io.github.ma1uta.matrix.event.message.Image;
import io.github.ma1uta.matrix.event.message.Location;
import io.github.ma1uta.matrix.event.message.Notice;
import io.github.ma1uta.matrix.event.message.RawMessageContent;
import io.github.ma1uta.matrix.event.message.Text;
import io.github.ma1uta.matrix.event.message.Video;
import java.lang.reflect.Type;
import javax.json.JsonObject;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;

public class RoomMessageDeserializer
implements JsonbDeserializer<RoomMessageContent> {
    private Jsonb jsonb = JsonbBuilder.create();

    protected Jsonb jsonb() {
        return this.jsonb;
    }

    public RoomMessageContent deserialize(JsonParser parser, DeserializationContext ctx, Type rtType) {
        JsonObject object = parser.getObject();
        if (object.get((Object)"msgtype") == null || object.isNull("msgtype")) {
            return this.parse(object, null, ctx);
        }
        String msgtype = object.getString("msgtype");
        String content = object.toString();
        switch (msgtype) {
            case "m.audio": {
                return (RoomMessageContent)this.jsonb().fromJson(content, Audio.class);
            }
            case "m.emote": {
                return (RoomMessageContent)this.jsonb().fromJson(content, Emote.class);
            }
            case "m.file": {
                return (RoomMessageContent)this.jsonb().fromJson(content, File.class);
            }
            case "m.image": {
                return (RoomMessageContent)this.jsonb().fromJson(content, Image.class);
            }
            case "m.location": {
                return (RoomMessageContent)this.jsonb().fromJson(content, Location.class);
            }
            case "m.notice": {
                return (RoomMessageContent)this.jsonb().fromJson(content, Notice.class);
            }
            case "m.text": {
                return (RoomMessageContent)this.jsonb().fromJson(content, Text.class);
            }
            case "m.video": {
                return (RoomMessageContent)this.jsonb().fromJson(content, Video.class);
            }
        }
        return this.parse(object, msgtype, ctx);
    }

    protected RawMessageContent parse(JsonObject object, String type, DeserializationContext ctx) {
        return new RawMessageContent((Object)object, type);
    }
}

