/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.support.jsonb;

import io.github.ma1uta.matrix.event.CallAnswer;
import io.github.ma1uta.matrix.event.CallCandidates;
import io.github.ma1uta.matrix.event.CallHangup;
import io.github.ma1uta.matrix.event.CallInvite;
import io.github.ma1uta.matrix.event.Direct;
import io.github.ma1uta.matrix.event.Event;
import io.github.ma1uta.matrix.event.ForwardedRoomKey;
import io.github.ma1uta.matrix.event.FullyRead;
import io.github.ma1uta.matrix.event.IgnoredUserList;
import io.github.ma1uta.matrix.event.Presence;
import io.github.ma1uta.matrix.event.PushRules;
import io.github.ma1uta.matrix.event.RawEvent;
import io.github.ma1uta.matrix.event.Receipt;
import io.github.ma1uta.matrix.event.RoomAliases;
import io.github.ma1uta.matrix.event.RoomAvatar;
import io.github.ma1uta.matrix.event.RoomCanonicalAlias;
import io.github.ma1uta.matrix.event.RoomCreate;
import io.github.ma1uta.matrix.event.RoomEncrypted;
import io.github.ma1uta.matrix.event.RoomEncryption;
import io.github.ma1uta.matrix.event.RoomGuestAccess;
import io.github.ma1uta.matrix.event.RoomHistoryVisibility;
import io.github.ma1uta.matrix.event.RoomJoinRules;
import io.github.ma1uta.matrix.event.RoomKey;
import io.github.ma1uta.matrix.event.RoomKeyRequest;
import io.github.ma1uta.matrix.event.RoomMember;
import io.github.ma1uta.matrix.event.RoomMessage;
import io.github.ma1uta.matrix.event.RoomMessageFeedback;
import io.github.ma1uta.matrix.event.RoomName;
import io.github.ma1uta.matrix.event.RoomPinned;
import io.github.ma1uta.matrix.event.RoomPowerLevels;
import io.github.ma1uta.matrix.event.RoomRedaction;
import io.github.ma1uta.matrix.event.RoomServerAcl;
import io.github.ma1uta.matrix.event.RoomThirdPartyInvite;
import io.github.ma1uta.matrix.event.RoomTopic;
import io.github.ma1uta.matrix.event.Sticker;
import io.github.ma1uta.matrix.event.Tag;
import io.github.ma1uta.matrix.event.Typing;
import java.lang.reflect.Type;
import java.util.Map;
import javax.json.JsonObject;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;

public class EventDeserializer
implements JsonbDeserializer<Event> {
    private Jsonb jsonb = JsonbBuilder.create();

    protected Jsonb jsonb() {
        return this.jsonb;
    }

    public Event deserialize(JsonParser parser, DeserializationContext ctx, Type rtType) {
        String type;
        JsonObject object = parser.getObject();
        String event = object.toString();
        if (object.get((Object)"type") == null || object.isNull("type")) {
            return this.parse(event, ctx, null);
        }
        switch (type = object.getString("type")) {
            case "m.call.answer": {
                return (Event)this.jsonb().fromJson(event, CallAnswer.class);
            }
            case "m.call.candidates": {
                return (Event)this.jsonb().fromJson(event, CallCandidates.class);
            }
            case "m.call.hangup": {
                return (Event)this.jsonb().fromJson(event, CallHangup.class);
            }
            case "m.call.invite": {
                return (Event)this.jsonb().fromJson(event, CallInvite.class);
            }
            case "m.direct": {
                return (Event)this.jsonb().fromJson(event, Direct.class);
            }
            case "m.forwarded_room_key": {
                return (Event)this.jsonb().fromJson(event, ForwardedRoomKey.class);
            }
            case "m.fully_read": {
                return (Event)this.jsonb().fromJson(event, FullyRead.class);
            }
            case "m.ignored_user_list": {
                return (Event)this.jsonb().fromJson(event, IgnoredUserList.class);
            }
            case "m.presence": {
                return (Event)this.jsonb().fromJson(event, Presence.class);
            }
            case "m.receipt": {
                return (Event)this.jsonb().fromJson(event, Receipt.class);
            }
            case "m.room.aliases": {
                return (Event)this.jsonb().fromJson(event, RoomAliases.class);
            }
            case "m.room.avatar": {
                return (Event)this.jsonb().fromJson(event, RoomAvatar.class);
            }
            case "m.room.canonical_alias": {
                return (Event)this.jsonb().fromJson(event, RoomCanonicalAlias.class);
            }
            case "m.room.create": {
                return (Event)this.jsonb().fromJson(event, RoomCreate.class);
            }
            case "m.room.guest_access": {
                return (Event)this.jsonb().fromJson(event, RoomGuestAccess.class);
            }
            case "m.room.encryption": {
                return (Event)this.jsonb().fromJson(event, RoomEncryption.class);
            }
            case "m.room.encrypted": {
                return (Event)this.jsonb().fromJson(event, RoomEncrypted.class);
            }
            case "m.room.history_visibility": {
                return (Event)this.jsonb().fromJson(event, RoomHistoryVisibility.class);
            }
            case "m.room.join_rules": {
                return (Event)this.jsonb().fromJson(event, RoomJoinRules.class);
            }
            case "m.room_key": {
                return (Event)this.jsonb().fromJson(event, RoomKey.class);
            }
            case "m.room_key_request": {
                return (Event)this.jsonb().fromJson(event, RoomKeyRequest.class);
            }
            case "m.room.member": {
                return (Event)this.jsonb().fromJson(event, RoomMember.class);
            }
            case "m.room.message": {
                return (Event)this.jsonb().fromJson(event, RoomMessage.class);
            }
            case "m.room.message.feedback": {
                return (Event)this.jsonb().fromJson(event, RoomMessageFeedback.class);
            }
            case "m.room.name": {
                return (Event)this.jsonb().fromJson(event, RoomName.class);
            }
            case "m.room.pinned_events": {
                return (Event)this.jsonb().fromJson(event, RoomPinned.class);
            }
            case "m.room.power_levels": {
                return (Event)this.jsonb().fromJson(event, RoomPowerLevels.class);
            }
            case "m.room.redaction": {
                return (Event)this.jsonb().fromJson(event, RoomRedaction.class);
            }
            case "m.room.third_party_invite": {
                return (Event)this.jsonb().fromJson(event, RoomThirdPartyInvite.class);
            }
            case "m.room.topic": {
                return (Event)this.jsonb().fromJson(event, RoomTopic.class);
            }
            case "m.sticker": {
                return (Event)this.jsonb().fromJson(event, Sticker.class);
            }
            case "m.tag": {
                return (Event)this.jsonb().fromJson(event, Tag.class);
            }
            case "m.typing": {
                return (Event)this.jsonb().fromJson(event, Typing.class);
            }
            case "m.room.server_acl": {
                return (Event)this.jsonb().fromJson(event, RoomServerAcl.class);
            }
            case "m.push_rules": {
                return (Event)this.jsonb().fromJson(event, PushRules.class);
            }
        }
        return this.parse(event, ctx, type);
    }

    protected Event parse(String event, DeserializationContext ctx, String type) {
        return new RawEvent((Map)this.jsonb().fromJson(event, Map.class), type);
    }
}

