/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.support.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import io.github.ma1uta.matrix.event.CallAnswer;
import io.github.ma1uta.matrix.event.CallCandidates;
import io.github.ma1uta.matrix.event.CallHangup;
import io.github.ma1uta.matrix.event.CallInvite;
import io.github.ma1uta.matrix.event.Direct;
import io.github.ma1uta.matrix.event.Dummy;
import io.github.ma1uta.matrix.event.Event;
import io.github.ma1uta.matrix.event.ForwardedRoomKey;
import io.github.ma1uta.matrix.event.FullyRead;
import io.github.ma1uta.matrix.event.IgnoredUserList;
import io.github.ma1uta.matrix.event.KeyVerificationAccept;
import io.github.ma1uta.matrix.event.KeyVerificationCancel;
import io.github.ma1uta.matrix.event.KeyVerificationKey;
import io.github.ma1uta.matrix.event.KeyVerificationMac;
import io.github.ma1uta.matrix.event.KeyVerificationRequest;
import io.github.ma1uta.matrix.event.KeyVerificationStart;
import io.github.ma1uta.matrix.event.PolicyRuleRoom;
import io.github.ma1uta.matrix.event.PolicyRuleServer;
import io.github.ma1uta.matrix.event.PolicyRuleUser;
import io.github.ma1uta.matrix.event.Presence;
import io.github.ma1uta.matrix.event.PushRules;
import io.github.ma1uta.matrix.event.RawEvent;
import io.github.ma1uta.matrix.event.Receipt;
import io.github.ma1uta.matrix.event.RoomAliases;
import io.github.ma1uta.matrix.event.RoomAvatar;
import io.github.ma1uta.matrix.event.RoomCanonicalAlias;
import io.github.ma1uta.matrix.event.RoomCreate;
import io.github.ma1uta.matrix.event.RoomEncrypted;
import io.github.ma1uta.matrix.event.RoomEncryption;
import io.github.ma1uta.matrix.event.RoomGuestAccess;
import io.github.ma1uta.matrix.event.RoomHistoryVisibility;
import io.github.ma1uta.matrix.event.RoomJoinRules;
import io.github.ma1uta.matrix.event.RoomKey;
import io.github.ma1uta.matrix.event.RoomKeyRequest;
import io.github.ma1uta.matrix.event.RoomMember;
import io.github.ma1uta.matrix.event.RoomMessage;
import io.github.ma1uta.matrix.event.RoomMessageFeedback;
import io.github.ma1uta.matrix.event.RoomName;
import io.github.ma1uta.matrix.event.RoomPinned;
import io.github.ma1uta.matrix.event.RoomPowerLevels;
import io.github.ma1uta.matrix.event.RoomRedaction;
import io.github.ma1uta.matrix.event.RoomServerAcl;
import io.github.ma1uta.matrix.event.RoomThirdPartyInvite;
import io.github.ma1uta.matrix.event.RoomTombstone;
import io.github.ma1uta.matrix.event.RoomTopic;
import io.github.ma1uta.matrix.event.Sticker;
import io.github.ma1uta.matrix.event.Tag;
import io.github.ma1uta.matrix.event.Typing;
import java.io.IOException;
import java.util.Map;

public class EventDeserializer
extends JsonDeserializer<Event> {
    public Event deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        ObjectCodec codec = parser.getCodec();
        JsonNode node = (JsonNode)codec.readTree(parser);
        JsonNode type = node.get("type");
        if (type == null || !type.isTextual()) {
            return this.parse(node, codec, ctxt, null);
        }
        switch (type.asText()) {
            case "m.call.answer": {
                return (Event)codec.treeToValue((TreeNode)node, CallAnswer.class);
            }
            case "m.call.candidates": {
                return (Event)codec.treeToValue((TreeNode)node, CallCandidates.class);
            }
            case "m.call.hangup": {
                return (Event)codec.treeToValue((TreeNode)node, CallHangup.class);
            }
            case "m.call.invite": {
                return (Event)codec.treeToValue((TreeNode)node, CallInvite.class);
            }
            case "m.direct": {
                return (Event)codec.treeToValue((TreeNode)node, Direct.class);
            }
            case "m.forwarded_room_key": {
                return (Event)codec.treeToValue((TreeNode)node, ForwardedRoomKey.class);
            }
            case "m.fully_read": {
                return (Event)codec.treeToValue((TreeNode)node, FullyRead.class);
            }
            case "m.ignored_user_list": {
                return (Event)codec.treeToValue((TreeNode)node, IgnoredUserList.class);
            }
            case "m.presence": {
                return (Event)codec.treeToValue((TreeNode)node, Presence.class);
            }
            case "m.receipt": {
                return (Event)codec.treeToValue((TreeNode)node, Receipt.class);
            }
            case "m.room.aliases": {
                return (Event)codec.treeToValue((TreeNode)node, RoomAliases.class);
            }
            case "m.room.avatar": {
                return (Event)codec.treeToValue((TreeNode)node, RoomAvatar.class);
            }
            case "m.room.canonical_alias": {
                return (Event)codec.treeToValue((TreeNode)node, RoomCanonicalAlias.class);
            }
            case "m.room.create": {
                return (Event)codec.treeToValue((TreeNode)node, RoomCreate.class);
            }
            case "m.room.guest_access": {
                return (Event)codec.treeToValue((TreeNode)node, RoomGuestAccess.class);
            }
            case "m.room.encryption": {
                return (Event)codec.treeToValue((TreeNode)node, RoomEncryption.class);
            }
            case "m.room.encrypted": {
                return (Event)codec.treeToValue((TreeNode)node, RoomEncrypted.class);
            }
            case "m.room.history_visibility": {
                return (Event)codec.treeToValue((TreeNode)node, RoomHistoryVisibility.class);
            }
            case "m.room.join_rules": {
                return (Event)codec.treeToValue((TreeNode)node, RoomJoinRules.class);
            }
            case "m.room_key": {
                return (Event)codec.treeToValue((TreeNode)node, RoomKey.class);
            }
            case "m.room_key_request": {
                return (Event)codec.treeToValue((TreeNode)node, RoomKeyRequest.class);
            }
            case "m.room.member": {
                return (Event)codec.treeToValue((TreeNode)node, RoomMember.class);
            }
            case "m.room.message": {
                return (Event)codec.treeToValue((TreeNode)node, RoomMessage.class);
            }
            case "m.room.message.feedback": {
                return (Event)codec.treeToValue((TreeNode)node, RoomMessageFeedback.class);
            }
            case "m.room.name": {
                return (Event)codec.treeToValue((TreeNode)node, RoomName.class);
            }
            case "m.room.pinned_events": {
                return (Event)codec.treeToValue((TreeNode)node, RoomPinned.class);
            }
            case "m.room.power_levels": {
                return (Event)codec.treeToValue((TreeNode)node, RoomPowerLevels.class);
            }
            case "m.room.redaction": {
                return (Event)codec.treeToValue((TreeNode)node, RoomRedaction.class);
            }
            case "m.room.third_party_invite": {
                return (Event)codec.treeToValue((TreeNode)node, RoomThirdPartyInvite.class);
            }
            case "m.room.topic": {
                return (Event)codec.treeToValue((TreeNode)node, RoomTopic.class);
            }
            case "m.sticker": {
                return (Event)codec.treeToValue((TreeNode)node, Sticker.class);
            }
            case "m.tag": {
                return (Event)codec.treeToValue((TreeNode)node, Tag.class);
            }
            case "m.typing": {
                return (Event)codec.treeToValue((TreeNode)node, Typing.class);
            }
            case "m.room.server_acl": {
                return (Event)codec.treeToValue((TreeNode)node, RoomServerAcl.class);
            }
            case "m.push_rules": {
                return (Event)codec.treeToValue((TreeNode)node, PushRules.class);
            }
            case "m.room.tombstone": {
                return (Event)codec.treeToValue((TreeNode)node, RoomTombstone.class);
            }
            case "m.dummy": {
                return (Event)codec.treeToValue((TreeNode)node, Dummy.class);
            }
            case "m.key.verification.accept": {
                return (Event)codec.treeToValue((TreeNode)node, KeyVerificationAccept.class);
            }
            case "m.key.verification.cancel": {
                return (Event)codec.treeToValue((TreeNode)node, KeyVerificationCancel.class);
            }
            case "m.key.verification.key": {
                return (Event)codec.treeToValue((TreeNode)node, KeyVerificationKey.class);
            }
            case "m.key.verification.mac": {
                return (Event)codec.treeToValue((TreeNode)node, KeyVerificationMac.class);
            }
            case "m.key.verification.request": {
                return (Event)codec.treeToValue((TreeNode)node, KeyVerificationRequest.class);
            }
            case "m.key.verification.start": {
                return (Event)codec.treeToValue((TreeNode)node, KeyVerificationStart.class);
            }
            case "m.policy.rule.room": {
                return (Event)codec.treeToValue((TreeNode)node, PolicyRuleRoom.class);
            }
            case "m.policy.rule.user": {
                return (Event)codec.treeToValue((TreeNode)node, PolicyRuleUser.class);
            }
            case "m.policy.rule.server": {
                return (Event)codec.treeToValue((TreeNode)node, PolicyRuleServer.class);
            }
        }
        return this.parse(node, codec, ctxt, type.asText());
    }

    protected Event parse(JsonNode jsonNode, ObjectCodec codec, DeserializationContext ctxt, String type) throws JsonProcessingException {
        return new RawEvent((Map)codec.treeToValue((TreeNode)jsonNode, Map.class), type);
    }
}

