/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.identity.api;

import io.github.ma1uta.matrix.identity.model.validation.PublishRequest;
import io.github.ma1uta.matrix.identity.model.validation.PublishResponse;
import io.github.ma1uta.matrix.identity.model.validation.ValidationResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;

@Api(value="Validation", description="Checking the validation of the 3pid ownership.")
@Path(value="/_matrix/identity/api/v1")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface ValidationApi {
    @ApiOperation(value="Determines if a given 3pid has been validated by a user.", response=ValidationResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Validation information for the session."), @ApiResponse(code=400, message="he session has not been validated. If the session has not been validated, then errcode will be M_SESSION_NOT_VALIDATED. If the session has timed out, then errcode will be M_SESSION_EXPIRED."), @ApiResponse(code=404, message="The Session ID or client secret were not found.")})
    @GET
    @Path(value="/3pid/getValidated3pid")
    public void validate(@ApiParam(value="The Session ID generated by the requestToken call.", required=true) @QueryParam(value="sid") String var1, @ApiParam(value="The client secret passed to the requestToken call.", required=true) @QueryParam(value="client_secret") String var2, @Context HttpServletRequest var3, @Suspended AsyncResponse var4);

    @ApiOperation(value="Publish an association between a session and a Matrix user ID.", notes="Future calls to /lookup for any of the session's 3pids will return this association.", response=PublishResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The association was published."), @ApiResponse(code=400, message="The association was not published. If the session has not been validated, then errcode will be M_SESSION_NOT_VALIDATED. If the session has timed out, then errcode will be M_SESSION_EXPIRED."), @ApiResponse(code=404, message="he Session ID or client secret were not found.")})
    @POST
    @Path(value="/bind")
    public void publish(@ApiParam(value="JSON boy request", required=true) PublishRequest var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);
}

