/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.identity.api;

import io.github.ma1uta.matrix.identity.model.key.KeyValidationResponse;
import io.github.ma1uta.matrix.identity.model.key.PublicKeyResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;

@Api(value="KeyManagement", description="An identity service has some long-term public-private keypairs. These are named in a scheme algorithm:identifier, e.g. ed25519:0. When signing an association, the standard Signing JSON algorithm applies.\nThe identity server may also keep track of some short-term public-private keypairs, which may have different usage and lifetime characteristics than the service's long-term keys.")
@Path(value="/_matrix/identity/api/v1/pubkey")
@Produces(value={"application/json"})
public interface KeyManagementApi {
    @ApiOperation(value="Get the public key for the passed key ID.", response=PublicKeyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The public key exists."), @ApiResponse(code=404, message="The public key was not found.")})
    @GET
    @Path(value="/{keyId}")
    public void get(@ApiParam(name="keyId", value="The ID of the key. This should take the form algorithm:identifier where algorithm identifies the signing algorithm, and the identifier is an opaque string.", required=true) @PathParam(value="keyId") String var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);

    @ApiOperation(value="Check whether a long-term public key is valid.", notes="The response should always be the same, provided the key exists.", response=KeyValidationResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The validity of the public key.")})
    @GET
    @Path(value="/isvalid")
    public void valid(@ApiParam(name="public_key", value="The unpadded base64-encoded public key to check.", required=true) @QueryParam(value="public_key") String var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);

    @ApiOperation(value="Check whether a short-term public key is valid.", response=KeyValidationResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The validity of the public key.")})
    @GET
    @Path(value="/ephemeral/isvalid")
    public void ephemeralValid(@ApiParam(name="public_key", value="The unpadded base64-encoded public key to check.", required=true) @QueryParam(value="public_key") String var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);
}

