/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.identity.api;

import io.github.ma1uta.matrix.common.EmptyResponse;
import io.github.ma1uta.matrix.common.ErrorResponse;
import io.github.ma1uta.matrix.identity.model.authentication.OpenIdInfo;
import io.github.ma1uta.matrix.identity.model.authentication.OpenIdRequest;
import io.github.ma1uta.matrix.identity.model.authentication.Token;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/identity/v2/account")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface AuthenticationApi {
    @Operation(summary="Exchanges an OpenID token from the homeserver for an access token to access the identity server.", description="The request body is the same as the values returned by /openid/request_token in the Client-Server API.", responses={@ApiResponse(responseCode="200", description="A token which can be used to authenticate future requests to the identity server.", content={@Content(schema=@Schema(implementation=Token.class))})})
    @POST
    @Path(value="/register")
    public void register(@RequestBody(description="JSON body request") OpenIdRequest var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Gets information about what user owns the access token used in the request.", responses={@ApiResponse(responseCode="200", description="The token holder's information.", content={@Content(schema=@Schema(implementation=OpenIdInfo.class))}), @ApiResponse(responseCode="403", description="The user must do something in order to use this endpoint. One example is an M_TERMS_NOT_SIGNED error where the user must agree to more terms.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="")
    public void getInfo(@Context UriInfo var1, @Context HttpHeaders var2, @Suspended AsyncResponse var3, @Context SecurityContext var4);

    @Operation(summary="Logs out the access token, preventing it from being used to authenticate future requests to the server.", responses={@ApiResponse(responseCode="200", description="The token was successfully logged out.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="401", description="The token is not registered or is otherwise unknown to the server.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="The user must do something in order to use this endpoint. One example is an M_TERMS_NOT_SIGNED error where the user must agree to more terms.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @Path(value="")
    public void logout(@Context UriInfo var1, @Context HttpHeaders var2, @Suspended AsyncResponse var3, @Context SecurityContext var4);
}

