/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix;

import io.github.ma1uta.matrix.IdParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class Id
implements CharSequence {
    private Collection<IdParseException> errors;

    public abstract char getSigil();

    public static Id valueOf(String mxid) {
        return IdParser.getInstance().parse(mxid);
    }

    public boolean isValid() {
        return this.errors() == null || this.errors().isEmpty();
    }

    public Collection<IdParseException> errors() {
        return this.errors == null ? Collections.emptyList() : this.errors;
    }

    public void errors(List<IdParseException> errors) {
        this.errors = new ArrayList<IdParseException>(errors);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public static class IdParseException
    extends RuntimeException {
        public IdParseException(String message) {
            super(message);
        }
    }
}

