/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import io.github.ma1uta.matrix.EventContent;
import io.github.ma1uta.matrix.events.CallAnswer;
import io.github.ma1uta.matrix.events.CallCandidates;
import io.github.ma1uta.matrix.events.CallHangup;
import io.github.ma1uta.matrix.events.CallInvite;
import io.github.ma1uta.matrix.events.Direct;
import io.github.ma1uta.matrix.events.ForwardedRoomKey;
import io.github.ma1uta.matrix.events.FullyRead;
import io.github.ma1uta.matrix.events.IgnoredUserList;
import io.github.ma1uta.matrix.events.Presence;
import io.github.ma1uta.matrix.events.RawEvent;
import io.github.ma1uta.matrix.events.Receipt;
import io.github.ma1uta.matrix.events.RoomAliases;
import io.github.ma1uta.matrix.events.RoomAvatar;
import io.github.ma1uta.matrix.events.RoomCanonicalAlias;
import io.github.ma1uta.matrix.events.RoomCreate;
import io.github.ma1uta.matrix.events.RoomEncryption;
import io.github.ma1uta.matrix.events.RoomGuestAccess;
import io.github.ma1uta.matrix.events.RoomHistoryVisibility;
import io.github.ma1uta.matrix.events.RoomJoinRules;
import io.github.ma1uta.matrix.events.RoomKey;
import io.github.ma1uta.matrix.events.RoomKeyRequest;
import io.github.ma1uta.matrix.events.RoomMember;
import io.github.ma1uta.matrix.events.RoomMessageFeedback;
import io.github.ma1uta.matrix.events.RoomName;
import io.github.ma1uta.matrix.events.RoomPinned;
import io.github.ma1uta.matrix.events.RoomPowerLevels;
import io.github.ma1uta.matrix.events.RoomRedaction;
import io.github.ma1uta.matrix.events.RoomServerAcl;
import io.github.ma1uta.matrix.events.RoomThirdPartyInvite;
import io.github.ma1uta.matrix.events.RoomTopic;
import io.github.ma1uta.matrix.events.Sticker;
import io.github.ma1uta.matrix.events.Tag;
import io.github.ma1uta.matrix.events.Typing;
import io.github.ma1uta.matrix.jackson.EncryptedMessageDeserializer;
import io.github.ma1uta.matrix.jackson.RoomMessageDeserializer;

public class EventContentDeserializer {
    public EventContent deserialize(JsonNode node, String type, ObjectCodec codec) throws JsonProcessingException {
        if (node == null || node.isNull()) {
            return null;
        }
        switch (type) {
            case "m.call.answer": {
                return (EventContent)codec.treeToValue((TreeNode)node, CallAnswer.class);
            }
            case "m.call.candidates": {
                return (EventContent)codec.treeToValue((TreeNode)node, CallCandidates.class);
            }
            case "m.call.hangup": {
                return (EventContent)codec.treeToValue((TreeNode)node, CallHangup.class);
            }
            case "m.call.invite": {
                return (EventContent)codec.treeToValue((TreeNode)node, CallInvite.class);
            }
            case "m.direct": {
                return (EventContent)codec.treeToValue((TreeNode)node, Direct.class);
            }
            case "m.forwarded_room_key": {
                return (EventContent)codec.treeToValue((TreeNode)node, ForwardedRoomKey.class);
            }
            case "m.fully_read": {
                return (EventContent)codec.treeToValue((TreeNode)node, FullyRead.class);
            }
            case "m.ignored_user_list": {
                return (EventContent)codec.treeToValue((TreeNode)node, IgnoredUserList.class);
            }
            case "m.presence": {
                return (EventContent)codec.treeToValue((TreeNode)node, Presence.class);
            }
            case "m.receipt": {
                return (EventContent)codec.treeToValue((TreeNode)node, Receipt.class);
            }
            case "m.room.aliases": {
                return (EventContent)codec.treeToValue((TreeNode)node, RoomAliases.class);
            }
            case "m.room.avatar": {
                return (EventContent)codec.treeToValue((TreeNode)node, RoomAvatar.class);
            }
            case "m.room.canonical_alias": {
                return (EventContent)codec.treeToValue((TreeNode)node, RoomCanonicalAlias.class);
            }
            case "m.room.create": {
                return (EventContent)codec.treeToValue((TreeNode)node, RoomCreate.class);
            }
            case "m.room.guest_access": {
                return (EventContent)codec.treeToValue((TreeNode)node, RoomGuestAccess.class);
            }
            case "m.room.encryption": {
                return (EventContent)codec.treeToValue((TreeNode)node, RoomEncryption.class);
            }
            case "m.room.encrypted": {
                return new EncryptedMessageDeserializer().deserialize(node, codec);
            }
            case "m.room.history_visibility": {
                return (EventContent)codec.treeToValue((TreeNode)node, RoomHistoryVisibility.class);
            }
            case "m.room.join_rules": {
                return (EventContent)codec.treeToValue((TreeNode)node, RoomJoinRules.class);
            }
            case "m.room_key": {
                return (EventContent)codec.treeToValue((TreeNode)node, RoomKey.class);
            }
            case "m.room_key_request": {
                return (EventContent)codec.treeToValue((TreeNode)node, RoomKeyRequest.class);
            }
            case "m.room.member": {
                return (EventContent)codec.treeToValue((TreeNode)node, RoomMember.class);
            }
            case "m.room.message": {
                return new RoomMessageDeserializer().deserialize(node, codec);
            }
            case "m.room.message.feedback": {
                return (EventContent)codec.treeToValue((TreeNode)node, RoomMessageFeedback.class);
            }
            case "m.room.name": {
                return (EventContent)codec.treeToValue((TreeNode)node, RoomName.class);
            }
            case "m.room.pinned_events": {
                return (EventContent)codec.treeToValue((TreeNode)node, RoomPinned.class);
            }
            case "m.room.power_levels": {
                return (EventContent)codec.treeToValue((TreeNode)node, RoomPowerLevels.class);
            }
            case "m.room.redaction": {
                return (EventContent)codec.treeToValue((TreeNode)node, RoomRedaction.class);
            }
            case "m.room.third_party_invite": {
                return (EventContent)codec.treeToValue((TreeNode)node, RoomThirdPartyInvite.class);
            }
            case "m.room.topic": {
                return (EventContent)codec.treeToValue((TreeNode)node, RoomTopic.class);
            }
            case "m.sticker": {
                return (EventContent)codec.treeToValue((TreeNode)node, Sticker.class);
            }
            case "m.tag": {
                return (EventContent)codec.treeToValue((TreeNode)node, Tag.class);
            }
            case "m.typing": {
                return (EventContent)codec.treeToValue((TreeNode)node, Typing.class);
            }
            case "m.room.server_acl": {
                return (EventContent)codec.treeToValue((TreeNode)node, RoomServerAcl.class);
            }
        }
        return new RawEvent(node);
    }
}

