/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import io.github.ma1uta.matrix.events.RoomEncrypted;
import io.github.ma1uta.matrix.events.encrypted.MegolmEncrypted;
import io.github.ma1uta.matrix.events.encrypted.OlmEncrypted;
import io.github.ma1uta.matrix.events.encrypted.RawEncrypted;

public class EncryptedMessageDeserializer {
    public RoomEncrypted deserialize(JsonNode node, ObjectCodec codec) throws JsonProcessingException {
        String algorithm;
        if (node == null) {
            return null;
        }
        JsonNode algorithmNode = node.get("algorithm");
        if (algorithmNode == null || !algorithmNode.isTextual()) {
            return new RawEncrypted(node, null);
        }
        switch (algorithm = algorithmNode.asText()) {
            case "m.megolm.v1.aes-sha2": {
                return (RoomEncrypted)codec.treeToValue((TreeNode)node, MegolmEncrypted.class);
            }
            case "m.olm.v1.curve25519-aes-sha2": {
                return (RoomEncrypted)codec.treeToValue((TreeNode)node, OlmEncrypted.class);
            }
        }
        return new RawEncrypted(node, algorithm);
    }
}

