/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.EventContent;
import io.github.ma1uta.matrix.events.nested.NotificationPowerLevel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;

@ApiModel(description="This event specifies the minimum level a user must have in order to perform a certain action. It also specifies the levels of each user in the room. If a user_id is in the users list, then that user_id has the associated power level. Otherwise they have the default level users_default. If users_default is not supplied, it is assumed to be 0. If the room contains no m.room.power_levels event, the room's creator has a power level of 100, and all other users have a power level of 0. The level required to send a certain event is governed by events, state_default and events_default. If an event type is specified in events, then the user must have at least the level specified in order to send that event. If the event type is not supplied, it defaults to events_default for Message Events and state_default for State Events. If there is no state_default in the m.room.power_levels event, the state_default is 50. If there is no events_default in the m.room.power_levels event, the events_default is 0. If the room contains no m.room.power_levels event, both the state_default and events_default are 0. The power level required to invite a user to the room, kick a user from the room, ban a user from the room, or redact an event, is defined by invite, kick, ban, and redact, respectively. Each of these levels defaults to 50 if they are not specified in the m.room.power_levels event, or if the room contains no m.room.power_levels event.")
public class RoomPowerLevels
implements EventContent {
    public static final byte DEFAULT_HIGH_LEVEL = 100;
    public static final byte DEFAULT_MEDIUM_LEVEL = 50;
    public static final byte DEFAULT_LOW_LEVEL = 0;
    @ApiModelProperty(value="The level required to ban a user. Defaults to 50 if unspecified.")
    private Byte ban = 50;
    @ApiModelProperty(value="The level required to send specific event types. This is a mapping from event type to power level required.")
    private Map<String, Byte> events;
    @ApiModelProperty(name="events_default", value="The default level required to send message events. Can be overridden by the events key. Defaults to 0 if unspecified.")
    @JsonProperty(value="events_default")
    private Byte eventsDefault = 0;
    @ApiModelProperty(value="The level required to invite a user. Defaults to 50 if unspecified.")
    private Byte invite = 50;
    @ApiModelProperty(value="The level required to kick a user. Defaults to 50 if unspecified.")
    private Byte kick = 50;
    @ApiModelProperty(value="The level required to redact an event. Defaults to 50 if unspecified.")
    private Byte redact = 50;
    @ApiModelProperty(name="state_default", value="The default level required to send state events. Can be overridden by the events key. Defaults to 50 if unspecified, but 0 if there is no m.room.power_levels event at all.")
    @JsonProperty(value="state_default")
    private Byte stateDefault;
    @ApiModelProperty(value="The power levels for specific users. This is a mapping from user_id to power level for that user.")
    private Map<String, Byte> users;
    @ApiModelProperty(name="users_default", value="The default power level for every user in the room, unless their user_id is mentioned in the users key. Defaults to 0 if unspecified.")
    @JsonProperty(value="users_default")
    private Byte usersDefault = 0;
    @ApiModelProperty(value="The power level requirements for specific notification types. This is a mapping from key to power level for that notifications key.")
    private NotificationPowerLevel notifications;

    public Byte getBan() {
        return this.ban;
    }

    public void setBan(Byte ban) {
        this.ban = ban;
    }

    public Map<String, Byte> getEvents() {
        return this.events;
    }

    public void setEvents(Map<String, Byte> events) {
        this.events = events;
    }

    public Byte getEventsDefault() {
        return this.eventsDefault;
    }

    public void setEventsDefault(Byte eventsDefault) {
        this.eventsDefault = eventsDefault;
    }

    public Byte getInvite() {
        return this.invite;
    }

    public void setInvite(Byte invite) {
        this.invite = invite;
    }

    public Byte getKick() {
        return this.kick;
    }

    public void setKick(Byte kick) {
        this.kick = kick;
    }

    public Byte getRedact() {
        return this.redact;
    }

    public void setRedact(Byte redact) {
        this.redact = redact;
    }

    public Byte getStateDefault() {
        return this.stateDefault;
    }

    public void setStateDefault(Byte stateDefault) {
        this.stateDefault = stateDefault;
    }

    public Map<String, Byte> getUsers() {
        return this.users;
    }

    public void setUsers(Map<String, Byte> users) {
        this.users = users;
    }

    public Byte getUsersDefault() {
        return this.usersDefault;
    }

    public void setUsersDefault(Byte usersDefault) {
        this.usersDefault = usersDefault;
    }

    public NotificationPowerLevel getNotifications() {
        return this.notifications;
    }

    public void setNotifications(NotificationPowerLevel notifications) {
        this.notifications = notifications;
    }
}

