/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import io.github.ma1uta.matrix.StrippedState;
import io.github.ma1uta.matrix.jackson.EventContentDeserializer;
import java.io.IOException;

public class StrippedDeserializer
extends JsonDeserializer<StrippedState> {
    public StrippedState deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec codec = parser.getCodec();
        JsonNode node = (JsonNode)codec.readTree(parser);
        JsonNode jsonType = node.get("type");
        if (jsonType == null || !jsonType.isTextual()) {
            throw new JsonParseException(parser, "Missing required field: type");
        }
        String type = jsonType.asText();
        StrippedState strippedState = new StrippedState();
        strippedState.setType(type);
        EventContentDeserializer contentDeserializer = new EventContentDeserializer();
        strippedState.setContent(contentDeserializer.deserialize(node.get("content"), type, codec));
        JsonNode stateKey = node.get("state_key");
        if (stateKey != null && stateKey.isTextual()) {
            strippedState.setStateKey(stateKey.asText());
        }
        return strippedState;
    }
}

