/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.github.ma1uta.matrix.Event;
import io.github.ma1uta.matrix.StrippedState;
import io.github.ma1uta.matrix.Unsigned;
import io.github.ma1uta.matrix.jackson.EventContentDeserializer;
import java.io.IOException;
import java.util.ArrayList;

public class EventDeserializer
extends JsonDeserializer<Event> {
    public Event deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        Event event = new Event();
        ObjectCodec codec = parser.getCodec();
        JsonNode node = (JsonNode)codec.readTree(parser);
        String type = this.asString(node.get("type"));
        if (this.isBlank(type)) {
            throw new JsonParseException(parser, "Missing required field: type");
        }
        event.setType(type);
        EventContentDeserializer contentDeserializer = new EventContentDeserializer();
        event.setContent(contentDeserializer.deserialize(node.get("content"), type, codec));
        String eventId = this.asString(node.get("event_id"));
        if (this.isBlank(eventId)) {
            throw new JsonParseException(parser, "Missing required field: event_id");
        }
        event.setEventId(eventId);
        String roomId = this.asString(node.get("room_id"));
        if (this.isBlank(roomId)) {
            throw new JsonParseException(parser, "Missing required field: room_id");
        }
        event.setRoomId(roomId);
        String sender = this.asString(node.get("sender"));
        if (this.isBlank(sender)) {
            throw new JsonParseException(parser, "Missing required field: sender");
        }
        event.setSender(sender);
        Long originServerTs = this.asLong(node.get("origin_server_ts"));
        if (originServerTs == null) {
            throw new JsonParseException(parser, "Missing required field: origin_server_ts");
        }
        event.setOriginServerTs(originServerTs);
        event.setUnsigned((Unsigned)codec.treeToValue((TreeNode)node.get("unsigned"), Unsigned.class));
        event.setPrevContent(contentDeserializer.deserialize(node.get("prev_content"), type, codec));
        event.setStateKey(this.asString(node.get("state_key")));
        JsonNode inviteRoomState = node.get("invite_room_state");
        if (inviteRoomState != null && inviteRoomState.isArray()) {
            ArrayNode nodes = (ArrayNode)inviteRoomState;
            ArrayList<StrippedState> strippedStates = new ArrayList<StrippedState>(nodes.size());
            for (JsonNode inviteItem : inviteRoomState) {
                strippedStates.add((StrippedState)codec.treeToValue((TreeNode)inviteItem, StrippedState.class));
            }
            event.setInviteRoomState(strippedStates);
        }
        return event;
    }

    protected String asString(JsonNode jsonElement) {
        return jsonElement != null && jsonElement.isTextual() ? jsonElement.asText() : null;
    }

    protected Long asLong(JsonNode jsonElement) {
        return jsonElement != null && jsonElement.isNumber() ? Long.valueOf(jsonElement.asLong()) : null;
    }

    protected boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }
}

