/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.event.content;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.event.content.EventContent;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="Cancels a key verification process/request. Typically sent as a to-device event.")
public class KeyVerificationCancelContent
implements EventContent {
    @Schema(name="transaction_id", description="The opaque identifier for the verification process/request.", required=true)
    @JsonbProperty(value="transaction_id")
    private String transactionId;
    @Schema(description="A human readable description of the code. The client should only rely on this string if it does not understand the code.", required=true)
    private String reason;
    @Schema(description="The error code for why the process/request was cancelled by the user. Error codes should use the Java package naming convention.", required=true, allowableValues={"m.user", "m.timeout", "m.unknown_transaction", "m.unknown_method", "m.unexpected_message", "m.key_mismatch", "m.user_mismatch", "m.invalid_message", "m.accepted"})
    private String code;

    @JsonProperty(value="transaction_id")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public static class CancelCode {
        public static final String M_USER = "m.user";
        public static final String M_TIMEOUT = "m.timeout";
        public static final String M_UNKNOWN_TRANSACTION = "m.unknown_transaction";
        public static final String M_UNKNOWN_METHOD = "m.unknown_method";
        public static final String M_UNEXPECTED_MESSAGE = "m.unexpected_message";
        public static final String M_KEY_MISMATCH = "m.key_mismatch";
        public static final String M_USER_MISMATCH = "m.user_mismatch";
        public static final String M_INVALID_MESSAGE = "m.invalid_message";
        public static final String M_ACCEPTED = "m.accepted";

        protected CancelCode() {
        }
    }
}

