/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.event.content;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.event.content.EventContent;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="Begins a key verification process. Typically sent as a to-device event.")
public class KeyVerificationStartContent
implements EventContent {
    @Schema(name="from_device", description="The device ID which is initiating the process.", required=true)
    @JsonbProperty(value="from_device")
    private String fromDevice;
    @Schema(name="transaction_id", description="An opaque identifier for the verification process. Must be unique with respect to the devices involved. Must be the same as the transaction_id given in the m.key.verification.request if this process is originating from a request.", required=true)
    @JsonbProperty(value="transaction_id")
    private String transactionId;
    @Schema(description="The verification method to use.", required=true)
    private String method;
    @Schema(name="next_method", description="Optional method to use to verify the other user's key with. Applicable when the method chosen only verifies one user's key.")
    @JsonbProperty(value="next_method")
    private String nextMethod;
    @Schema(name="key_agreement_protocol", description="The key agreement protocols the sending device understands. Must include at least curve25519.")
    @JsonbProperty(value="key_agreement_protocol")
    private List<String> keyAgreementProtocol;
    @Schema(description="The hash methods the sending device understands. Must include at least sha256.")
    private List<String> hashes;
    @Schema(name="message_authentication_codes", description="The message authentication codes that the sending device understands. Must include at least hkdf-hmac-sha256.")
    @JsonbProperty(value="message_authentication_codes")
    private List<String> messageAuthenticationCodes;
    @Schema(name="short_authentication_string", description="The SAS methods the sending device (and the sending device's user) understands. Must include at least decimal. Optionally can include emoji.", allowableValues={"decimal", "emoji"})
    @JsonbProperty(value="short_authentication_string")
    private List<String> shortAuthenticationString;

    @JsonProperty(value="from_device")
    public String getFromDevice() {
        return this.fromDevice;
    }

    public void setFromDevice(String fromDevice) {
        this.fromDevice = fromDevice;
    }

    @JsonProperty(value="transaction_id")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @JsonProperty(value="next_method")
    public String getNextMethod() {
        return this.nextMethod;
    }

    public void setNextMethod(String nextMethod) {
        this.nextMethod = nextMethod;
    }

    @JsonProperty(value="key_agreement_protocol")
    public List<String> getKeyAgreementProtocol() {
        return this.keyAgreementProtocol;
    }

    public void setKeyAgreementProtocol(List<String> keyAgreementProtocol) {
        this.keyAgreementProtocol = keyAgreementProtocol;
    }

    public List<String> getHashes() {
        return this.hashes;
    }

    public void setHashes(List<String> hashes) {
        this.hashes = hashes;
    }

    @JsonProperty(value="message_authentication_codes")
    public List<String> getMessageAuthenticationCodes() {
        return this.messageAuthenticationCodes;
    }

    public void setMessageAuthenticationCodes(List<String> messageAuthenticationCodes) {
        this.messageAuthenticationCodes = messageAuthenticationCodes;
    }

    @JsonProperty(value="short_authentication_string")
    public List<String> getShortAuthenticationString() {
        return this.shortAuthenticationString;
    }

    public void setShortAuthenticationString(List<String> shortAuthenticationString) {
        this.shortAuthenticationString = shortAuthenticationString;
    }
}

