/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.client.RequestParams;
import io.github.ma1uta.matrix.client.api.RoomApi;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import io.github.ma1uta.matrix.client.methods.AbstractMethods;
import io.github.ma1uta.matrix.client.model.room.CreateRoomRequest;
import io.github.ma1uta.matrix.client.model.room.InviteRequest;
import io.github.ma1uta.matrix.client.model.room.JoinRequest;
import io.github.ma1uta.matrix.client.model.room.JoinedRoomsResponse;
import io.github.ma1uta.matrix.client.model.room.KickRequest;
import io.github.ma1uta.matrix.client.model.room.NewVersion;
import io.github.ma1uta.matrix.client.model.room.PublicRoomsRequest;
import io.github.ma1uta.matrix.client.model.room.PublicRoomsResponse;
import io.github.ma1uta.matrix.client.model.room.ReplacementRoom;
import io.github.ma1uta.matrix.client.model.room.RoomId;
import io.github.ma1uta.matrix.client.model.room.RoomVisibility;
import io.github.ma1uta.matrix.client.model.room.UnbanRequest;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class RoomMethods
extends AbstractMethods {
    public RoomMethods(RequestFactory factory, RequestParams defaultParams) {
        super(factory, defaultParams);
    }

    public CompletableFuture<RoomId> create(CreateRoomRequest request) {
        return this.factory().post(RoomApi.class, "create", this.defaults(), request, RoomId.class);
    }

    public CompletableFuture<EmptyResponse> createAlias(RoomId roomId, String alias) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(alias, "Alias cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomAlias", alias);
        return this.factory().put(RoomApi.class, "createAlias", params, roomId, EmptyResponse.class);
    }

    public CompletableFuture<RoomId> resolveAlias(String alias) {
        Objects.requireNonNull(alias, "Alias cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomAlias", alias);
        return this.factory().get(RoomApi.class, "resolveAlias", params, RoomId.class);
    }

    public CompletableFuture<EmptyResponse> delete(String alias) {
        Objects.requireNonNull(alias, "Alias cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomAlias", alias);
        return this.factory().delete(RoomApi.class, "deleteAlias", params);
    }

    public CompletableFuture<List<String>> joinedRooms() {
        return this.factory().get(RoomApi.class, "joinedRooms", this.defaults(), JoinedRoomsResponse.class).thenApply(JoinedRoomsResponse::getJoinedRooms);
    }

    public CompletableFuture<EmptyResponse> invite(String roomId, InviteRequest request) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(request.getIdServer(), "IdServer cannot be empty.");
        Objects.requireNonNull(request.getAddress(), "Address cannot be empty.");
        Objects.requireNonNull(request.getMedium(), "Medium cannot be empty.");
        Objects.requireNonNull(request.getUserId(), "UserId cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId);
        return this.factory().post(RoomApi.class, "invite", params, request, EmptyResponse.class);
    }

    public CompletableFuture<RoomId> joinById(String roomId, JoinRequest request) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId);
        return this.factory().post(RoomApi.class, "joinById", params, request, RoomId.class);
    }

    public CompletableFuture<RoomId> joinByIdOrAlias(String idOrAlias) {
        Objects.requireNonNull(idOrAlias, "IdOrAlias cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomIdOrAlias", idOrAlias.toString());
        return this.factory().post(RoomApi.class, "joinByIdOrAlias", params, new JoinRequest(), RoomId.class);
    }

    public CompletableFuture<EmptyResponse> leave(String roomId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId);
        return this.factory().post(RoomApi.class, "leave", params, "", EmptyResponse.class);
    }

    public CompletableFuture<EmptyResponse> forget(String roomId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId);
        return this.factory().post(RoomApi.class, "forget", params, "", EmptyResponse.class);
    }

    public CompletableFuture<EmptyResponse> kick(String roomId, String userId, String reason) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId);
        KickRequest request = new KickRequest();
        request.setUserId(userId);
        request.setReason(reason);
        return this.factory().post(RoomApi.class, "kick", params, request, EmptyResponse.class);
    }

    public CompletableFuture<EmptyResponse> ban(String roomId, String userId, String reason) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId);
        KickRequest request = new KickRequest();
        request.setUserId(userId);
        request.setReason(reason);
        return this.factory().post(RoomApi.class, "ban", params, request, EmptyResponse.class);
    }

    public CompletableFuture<EmptyResponse> unban(String roomId, String userId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId);
        UnbanRequest request = new UnbanRequest();
        request.setUserId(userId);
        return this.factory().post(RoomApi.class, "unban", params, request, EmptyResponse.class);
    }

    public CompletableFuture<String> getVisibility(String roomId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId);
        return this.factory().get(RoomApi.class, "getVisibility", params, RoomVisibility.class).thenApply(RoomVisibility::getVisibility);
    }

    public CompletableFuture<EmptyResponse> setVisibility(String roomId, String visibility) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId);
        RoomVisibility request = new RoomVisibility();
        request.setVisibility(visibility);
        return this.factory().put(RoomApi.class, "setVisibility", params, request, EmptyResponse.class);
    }

    public CompletableFuture<PublicRoomsResponse> showPublicRooms(Long limit, String since, String server) {
        RequestParams params = this.defaults().clone().query("since", since).query("server", server).query("limit", limit);
        return this.factory().get(RoomApi.class, "showPublicRooms", params, PublicRoomsResponse.class);
    }

    public CompletableFuture<PublicRoomsResponse> searchPublicRooms(String server, PublicRoomsRequest request) {
        RequestParams params = this.defaults().clone().query("server", server);
        return this.factory().post(RoomApi.class, "searchPublicRooms", params, request, PublicRoomsResponse.class);
    }

    public CompletableFuture<ReplacementRoom> upgrade(String roomId, String newVersion) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(newVersion, "New version cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId);
        NewVersion request = new NewVersion();
        request.setNewVersion(newVersion);
        return this.factory().post(RoomApi.class, "upgrade", params, request, ReplacementRoom.class);
    }
}

