/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.Id;
import io.github.ma1uta.matrix.client.RequestParams;
import io.github.ma1uta.matrix.client.api.ThirdPartyProtocolApi;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import io.github.ma1uta.matrix.client.methods.AbstractMethods;
import io.github.ma1uta.matrix.protocol.Protocol;
import io.github.ma1uta.matrix.protocol.ProtocolLocation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.core.GenericType;

public class ProtocolMethods
extends AbstractMethods {
    public ProtocolMethods(RequestFactory factory, RequestParams defaultParams) {
        super(factory, defaultParams);
    }

    public CompletableFuture<Map<String, Protocol>> protocols() {
        return this.factory().get(ThirdPartyProtocolApi.class, "protocols", this.defaults(), new GenericType<Map<String, Protocol>>(){});
    }

    public CompletableFuture<Protocol> protocol(String protocol) {
        Objects.requireNonNull(protocol, "Protocol cannot be empty.");
        RequestParams params = this.defaults().clone().path("protocol", protocol);
        return this.factory().get(ThirdPartyProtocolApi.class, "protocol", params, Protocol.class);
    }

    public CompletableFuture<List<Protocol>> locations(String protocol, Map<String, String> queryParams) {
        Objects.requireNonNull(protocol, "Protocol cannot be empty.");
        RequestParams params = this.defaults().clone().path("protocol", protocol);
        params.getQueryParams().putAll(queryParams);
        return this.factory().get(ThirdPartyProtocolApi.class, "locationProtocol", params, new GenericType<List<Protocol>>(){});
    }

    public CompletableFuture<List<Protocol>> users(String protocol, Map<String, String> queryParams) {
        Objects.requireNonNull(protocol, "Protocol cannot be empty.");
        RequestParams params = this.defaults().clone().path("protocol", protocol);
        params.getQueryParams().putAll(queryParams);
        return this.factory().get(ThirdPartyProtocolApi.class, "userProtocol", params, new GenericType<List<Protocol>>(){});
    }

    public CompletableFuture<List<ProtocolLocation>> location(Id alias) {
        Objects.requireNonNull(alias, "Alias cannot be empty.");
        RequestParams params = this.defaults().clone().query("alias", alias.toString());
        return this.factory().get(ThirdPartyProtocolApi.class, "location", params, new GenericType<List<ProtocolLocation>>(){});
    }

    public CompletableFuture<List<ProtocolLocation>> user(Id userId) {
        Objects.requireNonNull(userId, "userId cannot be empty.");
        RequestParams params = this.defaults().clone().query("userid", userId.toString());
        return this.factory().get(ThirdPartyProtocolApi.class, "user", params, new GenericType<List<ProtocolLocation>>(){});
    }
}

