/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.client.RequestParams;
import io.github.ma1uta.matrix.client.api.ProfileApi;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import io.github.ma1uta.matrix.client.methods.AbstractMethods;
import io.github.ma1uta.matrix.client.model.profile.AvatarUrl;
import io.github.ma1uta.matrix.client.model.profile.DisplayName;
import io.github.ma1uta.matrix.client.model.profile.Profile;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class ProfileMethods
extends AbstractMethods {
    public ProfileMethods(RequestFactory factory, RequestParams defaultParams) {
        super(factory, defaultParams);
    }

    public CompletableFuture<EmptyResponse> setDisplayName(String displayName) {
        String userId = this.defaults().getUserId();
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        RequestParams params = this.defaults().clone().path("userId", userId);
        DisplayName request = new DisplayName();
        request.setDisplayName(displayName);
        return this.factory().put(ProfileApi.class, "setDisplayName", params, request, EmptyResponse.class);
    }

    public CompletableFuture<String> showDisplayName(String userId) {
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        RequestParams params = this.defaults().clone().path("userId", userId);
        return this.factory().get(ProfileApi.class, "showDisplayName", params, DisplayName.class).thenApply(DisplayName::getDisplayName);
    }

    public CompletableFuture<EmptyResponse> setAvaterUrl(String avatarUrl) {
        String userId = this.defaults().getUserId();
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        RequestParams params = this.defaults().clone().path("userId", userId);
        AvatarUrl request = new AvatarUrl();
        request.setAvatarUrl(avatarUrl);
        return this.factory().put(ProfileApi.class, "setAvatarUrl", params, request, EmptyResponse.class);
    }

    public CompletableFuture<String> showAvatarUrl(String userId) {
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        RequestParams params = this.defaults().clone().path("userId", userId);
        return this.factory().get(ProfileApi.class, "showAvatarUrl", params, AvatarUrl.class).thenApply(AvatarUrl::getAvatarUrl);
    }

    public CompletableFuture<Profile> profile(String userId) {
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        RequestParams params = this.defaults().clone().path("userId", userId);
        return this.factory().get(ProfileApi.class, "profile", params, Profile.class);
    }
}

