/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.client.RequestParams;
import io.github.ma1uta.matrix.client.api.EncryptionApi;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import io.github.ma1uta.matrix.client.methods.AbstractMethods;
import io.github.ma1uta.matrix.client.model.encryption.ChangesResponse;
import io.github.ma1uta.matrix.client.model.encryption.ClaimRequest;
import io.github.ma1uta.matrix.client.model.encryption.ClaimResponse;
import io.github.ma1uta.matrix.client.model.encryption.QueryRequest;
import io.github.ma1uta.matrix.client.model.encryption.QueryResponse;
import io.github.ma1uta.matrix.client.model.encryption.UploadRequest;
import io.github.ma1uta.matrix.client.model.encryption.UploadResponse;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class EncryptionMethods
extends AbstractMethods {
    public EncryptionMethods(RequestFactory factory, RequestParams defaultParams) {
        super(factory, defaultParams);
    }

    public CompletableFuture<UploadResponse> uploadKey(UploadRequest request) {
        return this.factory().post(EncryptionApi.class, "uploadKey", this.defaults(), request, UploadResponse.class);
    }

    public CompletableFuture<QueryResponse> query(QueryRequest request) {
        if (request.getDeviceKeys() == null || request.getDeviceKeys().isEmpty()) {
            throw new NullPointerException("DeviceKeys cannot be empty.");
        }
        return this.factory().post(EncryptionApi.class, "query", this.defaults(), request, QueryResponse.class);
    }

    public CompletableFuture<ClaimResponse> claim(ClaimRequest request) {
        if (request.getOneTimeKeys().isEmpty()) {
            throw new NullPointerException("OneTimeKeys cannot be empty.");
        }
        return this.factory().post(EncryptionApi.class, "claim", this.defaults(), request, ClaimResponse.class);
    }

    public CompletableFuture<ChangesResponse> changes(String from, String to) {
        Objects.requireNonNull(from, "From cannot be empty.");
        Objects.requireNonNull(to, "To cannot be empty.");
        RequestParams params = this.defaults().clone().query("from", from).query("to", to);
        return this.factory().get(EncryptionApi.class, "changes", params, ChangesResponse.class);
    }
}

