/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.sync;

import io.github.ma1uta.matrix.client.methods.SyncMethods;
import io.github.ma1uta.matrix.client.model.sync.SyncResponse;
import io.github.ma1uta.matrix.client.sync.SyncParams;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncLoop
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncLoop.class);
    private final SyncMethods syncMethods;
    private BiFunction<SyncResponse, SyncParams, SyncParams> inboundListener;
    private SyncParams init = new SyncParams();
    private final SyncParams current = new SyncParams();

    public SyncLoop(SyncMethods syncMethods) {
        this.syncMethods = syncMethods;
    }

    protected SyncMethods getSyncMethods() {
        return this.syncMethods;
    }

    public BiFunction<SyncResponse, SyncParams, SyncParams> getInboundListener() {
        return this.inboundListener;
    }

    public void setInboundListener(BiFunction<SyncResponse, SyncParams, SyncParams> inboundListener) {
        this.inboundListener = inboundListener;
    }

    public SyncParams getInit() {
        return this.init;
    }

    public void setInit(SyncParams init) {
        this.init = init;
    }

    public SyncParams getCurrent() {
        return new SyncParams(this.current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrent(SyncParams newParams) {
        if (newParams != null) {
            SyncParams syncParams = this.current;
            synchronized (syncParams) {
                this.current.from(newParams);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Objects.requireNonNull(this.getSyncMethods(), "The Matrix client must be specified.");
        Objects.requireNonNull(this.getInboundListener(), "Not found inbound listeners, the sync will erase the response.");
        this.setCurrent(this.getInit());
        while (!Thread.interrupted()) {
            try {
                CompletableFuture<SyncResponse> future;
                SyncParams syncParams = this.current;
                synchronized (syncParams) {
                    future = this.getSyncMethods().sync(this.current.getFilter(), this.current.getNextBatch(), this.current.isFullState(), this.current.getPresence(), this.current.getTimeout());
                }
                SyncResponse sync = future.get(2L * this.current.getTimeout(), TimeUnit.MILLISECONDS);
                SyncParams syncParams2 = this.current;
                synchronized (syncParams2) {
                    this.current.setNextBatch(sync.getNextBatch());
                }
                this.setCurrent(this.getInboundListener().apply(sync, new SyncParams(this.current)));
            }
            catch (TimeoutException e) {
                LOGGER.error("Timeout exceeded", (Throwable)e);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted", (Throwable)e);
                return;
            }
            catch (Exception e) {
                LOGGER.error("Exception: ", (Throwable)e);
            }
        }
    }
}

