/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.sync;

import io.github.ma1uta.matrix.client.methods.blocked.SyncMethods;
import io.github.ma1uta.matrix.client.model.sync.SyncResponse;
import io.github.ma1uta.matrix.client.sync.SyncParams;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncLoop
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncLoop.class);
    private final SyncMethods syncMethods;
    private final BiConsumer<SyncResponse, SyncParams> inboundListener;
    private final SyncParams state = new SyncParams();
    private SyncParams init = null;

    public SyncLoop(SyncMethods syncMethods, BiConsumer<SyncResponse, SyncParams> inboundListener) {
        this.syncMethods = syncMethods;
        this.inboundListener = inboundListener;
    }

    public SyncParams getInit() {
        return this.init;
    }

    public void setInit(SyncParams init) {
        this.init = init;
    }

    @Override
    public void run() {
        Objects.requireNonNull(this.syncMethods, "The Matrix client must be specified.");
        Objects.requireNonNull(this.inboundListener, "Not found inbound listeners, the sync will erase the response.");
        if (this.getInit() != null) {
            this.state.from(this.getInit());
        }
        LOGGER.info("SyncLoop started");
        while (!Thread.interrupted() && !this.state.isTerminate()) {
            try {
                SyncResponse sync = this.syncMethods.sync(this.state.getFilter(), this.state.getNextBatch(), this.state.isFullState(), this.state.getPresence(), this.state.getTimeout());
                this.state.setNextBatch(sync.getNextBatch());
                this.inboundListener.accept(sync, this.state);
            }
            catch (Exception e) {
                LOGGER.error("Exception: ", (Throwable)e);
            }
        }
        LOGGER.info("SyncLoop stopped");
    }
}

