/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods.async;

import io.github.ma1uta.matrix.client.ConnectionInfo;
import io.github.ma1uta.matrix.client.model.typing.TypingRequest;
import io.github.ma1uta.matrix.client.rest.async.TypingApi;
import io.github.ma1uta.matrix.common.EmptyResponse;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class TypingAsyncMethods {
    private final TypingApi typingApi;
    private final ConnectionInfo connectionInfo;

    public TypingAsyncMethods(RestClientBuilder restClientBuilder, ConnectionInfo connectionInfo) {
        this.typingApi = (TypingApi)restClientBuilder.build(TypingApi.class);
        this.connectionInfo = connectionInfo;
    }

    public CompletableFuture<EmptyResponse> typing(String roomId, Boolean typing, Long timeout) {
        String userId = this.connectionInfo.getUserId();
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        Objects.requireNonNull(typing, "Typing cannot be empty.");
        TypingRequest request = new TypingRequest();
        request.setTyping(typing);
        request.setTimeout(timeout);
        return this.typingApi.typing(roomId, userId, request).toCompletableFuture();
    }
}

