/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods.async;

import io.github.ma1uta.matrix.client.model.receipt.ReadMarkersRequest;
import io.github.ma1uta.matrix.client.rest.async.ReceiptApi;
import io.github.ma1uta.matrix.common.EmptyResponse;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class ReceiptAsyncMethods {
    private final ReceiptApi receiptApi;

    public ReceiptAsyncMethods(RestClientBuilder restClientBuilder) {
        this.receiptApi = (ReceiptApi)restClientBuilder.build(ReceiptApi.class);
    }

    public CompletableFuture<EmptyResponse> sendReceipt(String roomId, String eventId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(eventId, "EventId cannot be empty.");
        return this.receiptApi.receipt(roomId, "m.read", eventId).toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> readMarkers(String roomId, ReadMarkersRequest request) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        return this.receiptApi.readMarkers(roomId, request).toCompletableFuture();
    }
}

