/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.client.AbstractClientBuilder;
import io.github.ma1uta.matrix.client.ConnectionInfo;
import io.github.ma1uta.matrix.client.MatrixClient;
import io.github.ma1uta.matrix.client.methods.async.AccountAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.AuthAsyncMethods;
import io.github.ma1uta.matrix.client.methods.blocked.AccountMethods;
import io.github.ma1uta.matrix.client.methods.blocked.AuthMethods;
import io.github.ma1uta.matrix.client.model.auth.LoginResponse;
import java.util.concurrent.ExecutorService;

public class StandaloneClient
extends MatrixClient {
    public StandaloneClient(String domain) {
        super(domain);
    }

    public StandaloneClient(ConnectionInfo connectionInfo) {
        this(connectionInfo, null);
    }

    public StandaloneClient(ConnectionInfo connectionInfo, ExecutorService executorService) {
        super(connectionInfo, executorService);
    }

    public AuthAsyncMethods authAsync() {
        return this.getMethod(AuthAsyncMethods.class, () -> new AuthAsyncMethods(this.getClientBuilder(), this::afterLogin, this::afterLogout));
    }

    public AuthMethods auth() {
        return this.getMethod(AuthMethods.class, () -> new AuthMethods(this.getClientBuilder(), this::afterLogin, this::afterLogout));
    }

    @Override
    public AccountAsyncMethods accountAsync() {
        return this.getMethod(AccountAsyncMethods.class, () -> new AccountAsyncMethods(this.getClientBuilder(), this::afterLogin));
    }

    @Override
    public AccountMethods account() {
        return this.getMethod(AccountMethods.class, () -> new AccountMethods(this.getClientBuilder(), this::afterLogin));
    }

    @Override
    public void close() {
        this.authAsync().logout();
    }

    public LoginResponse afterLogin(LoginResponse loginResponse) {
        if (loginResponse == null) {
            this.afterLogout(null);
        } else {
            this.getConnectionInfo().setUserId(loginResponse.getUserId());
            this.getConnectionInfo().setAccessToken(loginResponse.getAccessToken());
            this.getConnectionInfo().setDeviceId(loginResponse.getDeviceId());
            this.getConnectionInfo().setServerInfo(loginResponse.getWellKnown());
        }
        return loginResponse;
    }

    public EmptyResponse afterLogout(EmptyResponse response) {
        this.getConnectionInfo().setAccessToken(null);
        this.getConnectionInfo().setDeviceId(null);
        return response;
    }

    public static class Builder
    extends AbstractClientBuilder<StandaloneClient> {
        @Override
        public StandaloneClient newInstance() {
            return new StandaloneClient(this.connectionInfo);
        }
    }
}

