/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client;

import io.github.ma1uta.matrix.client.ConnectionInfo;
import io.github.ma1uta.matrix.client.HomeServerResolver;
import io.github.ma1uta.matrix.client.ResolvedHomeserver;
import io.github.ma1uta.matrix.client.filter.AuthorizationFilter;
import io.github.ma1uta.matrix.client.filter.ContentTypeFilter;
import io.github.ma1uta.matrix.client.filter.ErrorFilter;
import io.github.ma1uta.matrix.client.filter.LoggingFilter;
import io.github.ma1uta.matrix.client.methods.AccountMethods;
import io.github.ma1uta.matrix.client.methods.AdminMethods;
import io.github.ma1uta.matrix.client.methods.CapabilityMethods;
import io.github.ma1uta.matrix.client.methods.ClientConfigMethods;
import io.github.ma1uta.matrix.client.methods.ContentMethods;
import io.github.ma1uta.matrix.client.methods.DeviceMethods;
import io.github.ma1uta.matrix.client.methods.EncryptionMethods;
import io.github.ma1uta.matrix.client.methods.EventContextMethods;
import io.github.ma1uta.matrix.client.methods.EventMethods;
import io.github.ma1uta.matrix.client.methods.FilterMethods;
import io.github.ma1uta.matrix.client.methods.PresenceMethods;
import io.github.ma1uta.matrix.client.methods.ProfileMethods;
import io.github.ma1uta.matrix.client.methods.ProtocolMethods;
import io.github.ma1uta.matrix.client.methods.PushMethods;
import io.github.ma1uta.matrix.client.methods.ReceiptMethods;
import io.github.ma1uta.matrix.client.methods.ReportMethods;
import io.github.ma1uta.matrix.client.methods.RoomMethods;
import io.github.ma1uta.matrix.client.methods.SearchMethods;
import io.github.ma1uta.matrix.client.methods.SendToDeviceMethods;
import io.github.ma1uta.matrix.client.methods.SyncMethods;
import io.github.ma1uta.matrix.client.methods.TagMethods;
import io.github.ma1uta.matrix.client.methods.TypingMethods;
import io.github.ma1uta.matrix.client.methods.UserDirectoryMethods;
import io.github.ma1uta.matrix.client.methods.VersionMethods;
import io.github.ma1uta.matrix.client.methods.VoipMethods;
import io.github.ma1uta.matrix.impl.RestClientBuilderConfigurer;
import java.io.Closeable;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public abstract class MatrixClient
implements Closeable {
    private volatile URL homeserverURL = null;
    private volatile RestClientBuilder builder = null;
    private volatile HostnameVerifier hostnameVerifier = null;
    private final HomeServerResolver homeServerResolver = new HomeServerResolver();
    private final Map<Class<?>, Object> methods = new ConcurrentHashMap();
    private final AuthorizationFilter authorizationFilter;
    private final ConnectionInfo connectionInfo;

    public MatrixClient(String domain) {
        this(new ConnectionInfo(domain));
    }

    public MatrixClient(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        this.authorizationFilter = new AuthorizationFilter(this.connectionInfo);
    }

    public URL getHomeserverUrl() {
        this.resolveHomeserver();
        return this.homeserverURL;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    protected synchronized void resolveHomeserver() {
        if (this.homeserverURL == null) {
            Optional<ResolvedHomeserver> optionalResolvedHomeserver = this.homeServerResolver.resolve(this.connectionInfo.getDomain());
            if (optionalResolvedHomeserver.isPresent()) {
                ResolvedHomeserver homeserver = optionalResolvedHomeserver.get();
                this.homeserverURL = homeserver.getUrl();
                this.hostnameVerifier = homeserver.getOptionalHostnameVerifier().orElse(null);
            } else {
                throw new IllegalStateException("Unable to resolve homeserver url: " + this.connectionInfo.getDomain());
            }
        }
    }

    protected RestClientBuilder newClientBuilder() {
        this.resolveHomeserver();
        RestClientBuilder builder = ((RestClientBuilder)((RestClientBuilder)((RestClientBuilder)((RestClientBuilder)RestClientBuilder.newBuilder().register((Object)new ErrorFilter())).register((Object)new LoggingFilter())).register((Object)this.authorizationFilter)).register((Object)new ContentTypeFilter())).baseUrl(this.getHomeserverUrl());
        if (this.hostnameVerifier != null) {
            builder.hostnameVerifier(this.hostnameVerifier);
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RestClientBuilder getClientBuilder() {
        if (this.builder == null) {
            MatrixClient matrixClient = this;
            synchronized (matrixClient) {
                if (this.builder != null) {
                    return this.builder;
                }
                this.builder = this.newClientBuilder();
                ServiceLoader.load(RestClientBuilderConfigurer.class).iterator().forEachRemaining(c -> c.configure(this.builder));
            }
        }
        return this.builder;
    }

    protected <T> T getMethod(Class<T> clazz, Supplier<T> creator) {
        return clazz.cast(this.methods.computeIfAbsent(clazz, key -> creator.get()));
    }

    public String getDomain() {
        return this.getConnectionInfo().getDomain();
    }

    public String getAccessToken() {
        return this.getConnectionInfo().getAccessToken();
    }

    @Override
    public void close() {
    }

    public abstract AccountMethods account();

    public AdminMethods admin() {
        return this.getMethod(AdminMethods.class, () -> new AdminMethods(this.getClientBuilder()));
    }

    public ClientConfigMethods clientConfig() {
        return this.getMethod(ClientConfigMethods.class, () -> new ClientConfigMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public ContentMethods content() {
        return this.getMethod(ContentMethods.class, () -> new ContentMethods(this.getClientBuilder()));
    }

    public DeviceMethods device() {
        return this.getMethod(DeviceMethods.class, () -> new DeviceMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public EncryptionMethods encryption() {
        return this.getMethod(EncryptionMethods.class, () -> new EncryptionMethods(this.getClientBuilder()));
    }

    public EventContextMethods eventContext() {
        return this.getMethod(EventContextMethods.class, () -> new EventContextMethods(this.getClientBuilder()));
    }

    public PresenceMethods presence() {
        return this.getMethod(PresenceMethods.class, () -> new PresenceMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public ProfileMethods profile() {
        return this.getMethod(ProfileMethods.class, () -> new ProfileMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public ReceiptMethods receipt() {
        return this.getMethod(ReceiptMethods.class, () -> new ReceiptMethods(this.getClientBuilder()));
    }

    public ReportMethods report() {
        return this.getMethod(ReportMethods.class, () -> new ReportMethods(this.getClientBuilder()));
    }

    public SearchMethods search() {
        return this.getMethod(SearchMethods.class, () -> new SearchMethods(this.getClientBuilder()));
    }

    public SendToDeviceMethods sendToDevice() {
        return this.getMethod(SendToDeviceMethods.class, () -> new SendToDeviceMethods(this.getClientBuilder()));
    }

    public SyncMethods sync() {
        return this.getMethod(SyncMethods.class, () -> new SyncMethods(this.getClientBuilder()));
    }

    public EventMethods event() {
        return this.getMethod(EventMethods.class, () -> new EventMethods(this.getClientBuilder()));
    }

    public FilterMethods filter() {
        return this.getMethod(FilterMethods.class, () -> new FilterMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public RoomMethods room() {
        return this.getMethod(RoomMethods.class, () -> new RoomMethods(this.getClientBuilder()));
    }

    public TagMethods tag() {
        return this.getMethod(TagMethods.class, () -> new TagMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public TypingMethods typing() {
        return this.getMethod(TypingMethods.class, () -> new TypingMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public UserDirectoryMethods userDirectory() {
        return this.getMethod(UserDirectoryMethods.class, () -> new UserDirectoryMethods(this.getClientBuilder()));
    }

    public VersionMethods versions() {
        return this.getMethod(VersionMethods.class, () -> new VersionMethods(this.getClientBuilder()));
    }

    public VoipMethods turnServers() {
        return this.getMethod(VoipMethods.class, () -> new VoipMethods(this.getClientBuilder()));
    }

    public PushMethods push() {
        return this.getMethod(PushMethods.class, () -> new PushMethods(this.getClientBuilder()));
    }

    public ProtocolMethods protocol() {
        return this.getMethod(ProtocolMethods.class, () -> new ProtocolMethods(this.getClientBuilder()));
    }

    public CapabilityMethods capabilities() {
        return this.getMethod(CapabilityMethods.class, () -> new CapabilityMethods(this.getClientBuilder()));
    }

    public String getUserId() {
        return this.getConnectionInfo().getUserId();
    }
}

