/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.client.model.content.ContentConfig;
import io.github.ma1uta.matrix.client.model.content.ContentUri;
import io.github.ma1uta.matrix.client.rest.ContentApi;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class ContentMethods {
    private final ContentApi contentApi;

    public ContentMethods(RestClientBuilder restClientBuilder) {
        this.contentApi = (ContentApi)restClientBuilder.build(ContentApi.class);
    }

    public CompletableFuture<ContentUri> upload(InputStream inputStream, String filename, String contentType) {
        return this.contentApi.upload(inputStream, filename, contentType).toCompletableFuture();
    }

    public CompletableFuture<InputStream> download(String serverName, String mediaId, Boolean allowRemote) {
        Objects.requireNonNull(serverName, "ServerName cannot be empty.");
        Objects.requireNonNull(mediaId, "MediaId cannot be empty.");
        return this.contentApi.download(serverName, mediaId, allowRemote).toCompletableFuture();
    }

    public CompletableFuture<InputStream> thumbnail(String serverName, String mediaId, Long width, Long height, String method, Boolean allowRemote) {
        Objects.requireNonNull(serverName, "ServerName cannot be empty.");
        Objects.requireNonNull(mediaId, "MediaId cannot be empty.");
        return this.contentApi.thumbnail(serverName, mediaId, width, height, method, allowRemote).toCompletableFuture();
    }

    public CompletableFuture<Map<String, String>> previewInfo(String url, String ts) {
        Objects.requireNonNull(url, "Url cannot be empty.");
        return this.contentApi.previewUrl(url, ts).toCompletableFuture();
    }

    public CompletableFuture<ContentConfig> getUploadSize() {
        return this.contentApi.config().toCompletableFuture();
    }
}

