/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.client.ConnectionInfo;
import io.github.ma1uta.matrix.client.model.presence.PresenceRequest;
import io.github.ma1uta.matrix.client.model.presence.PresenceStatus;
import io.github.ma1uta.matrix.client.rest.PresenceApi;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class PresenceMethods {
    private final PresenceApi presenceApi;
    private final ConnectionInfo connectionInfo;

    public PresenceMethods(RestClientBuilder restClientBuilder, ConnectionInfo connectionInfo) {
        this.presenceApi = (PresenceApi)restClientBuilder.build(PresenceApi.class);
        this.connectionInfo = connectionInfo;
    }

    public CompletableFuture<EmptyResponse> setPresenceStatus(String presence, String status) {
        String userId = this.connectionInfo.getUserId();
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        Objects.requireNonNull(presence, "Presence cannot be empty.");
        PresenceRequest request = new PresenceRequest();
        request.setPresence(presence);
        request.setStatusMsg(status);
        return this.presenceApi.setPresenceStatus(userId, request).toCompletableFuture();
    }

    public CompletableFuture<PresenceStatus> getPresenceStatus(String userId) {
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        return this.presenceApi.getPresenceStatus(userId).toCompletableFuture();
    }
}

