/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.client.AbstractClientBuilder;
import io.github.ma1uta.matrix.client.ConnectionInfo;
import io.github.ma1uta.matrix.client.MatrixClient;
import io.github.ma1uta.matrix.client.methods.AccountMethods;
import io.github.ma1uta.matrix.client.methods.AuthMethods;
import io.github.ma1uta.matrix.client.model.auth.LoginResponse;

public class StandaloneClient
extends MatrixClient {
    public StandaloneClient(String domain) {
        super(domain);
    }

    public StandaloneClient(ConnectionInfo connectionInfo) {
        super(connectionInfo);
    }

    public AuthMethods auth() {
        return this.getMethod(AuthMethods.class, () -> new AuthMethods(this.getClientBuilder(), this::afterLogin, this::afterLogout));
    }

    @Override
    public AccountMethods account() {
        return this.getMethod(AccountMethods.class, () -> new AccountMethods(this.getClientBuilder(), this::afterLogin));
    }

    @Override
    public void close() {
        this.auth().logout();
    }

    public LoginResponse afterLogin(LoginResponse loginResponse) {
        if (loginResponse == null) {
            this.afterLogout(null);
        } else {
            this.getConnectionInfo().setUserId(loginResponse.getUserId());
            this.getConnectionInfo().setAccessToken(loginResponse.getAccessToken());
            this.getConnectionInfo().setDeviceId(loginResponse.getDeviceId());
            this.getConnectionInfo().setServerInfo(loginResponse.getWellKnown());
        }
        return loginResponse;
    }

    public EmptyResponse afterLogout(EmptyResponse response) {
        this.getConnectionInfo().setAccessToken(null);
        this.getConnectionInfo().setDeviceId(null);
        return response;
    }

    public static class Builder
    extends AbstractClientBuilder<StandaloneClient> {
        @Override
        public StandaloneClient newInstance() {
            return new StandaloneClient(this.connectionInfo);
        }
    }
}

