/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.ErrorResponse;
import io.github.ma1uta.matrix.Id;
import io.github.ma1uta.matrix.Page;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.event.JoinedMembersResponse;
import io.github.ma1uta.matrix.client.model.event.MembersResponse;
import io.github.ma1uta.matrix.client.model.event.RedactRequest;
import io.github.ma1uta.matrix.client.model.event.SendEventResponse;
import io.github.ma1uta.matrix.event.Event;
import io.github.ma1uta.matrix.event.content.EventContent;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0/rooms")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface EventApi {
    @Operation(summary="Get a single event based on roomId/eventId. You must have permission to retrieve this event e.g. by being a member in the room for this event.", responses={@ApiResponse(responseCode="200", description="The full event.", content={@Content(schema=@Schema(implementation=Event.class))}), @ApiResponse(responseCode="404", description="The event was not found or you do not have permission to read this event.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room participation"})
    @GET
    @Secured
    @Path(value="/{roomId}/event/{eventId}")
    public void roomEvent(@Parameter(description="The ID of the room the event is in.", required=true) @PathParam(value="roomId") Id var1, @Parameter(description="The event ID to get.", required=true) @PathParam(value="eventId") Id var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @Operation(summary="Looks up the contents of a state event in a room. If the user is joined to the room then the state is taken from the current state of the room. If the user has left the room then the state is taken from the state of the room when they left.", responses={@ApiResponse(responseCode="200", description="The content of the state event.", content={@Content(schema=@Schema(implementation=EventContent.class))}), @ApiResponse(responseCode="403", description="You aren't a member of the room and weren't previously a member of the room.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="The room has no state with the given type or key.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room participation"})
    @GET
    @Secured
    @Path(value="/{roomId}/state/{eventType}/{stateKey}")
    public void roomEventWithTypeAndState(@Parameter(description="The room to look up the state in.", required=true) @PathParam(value="roomId") Id var1, @Parameter(description="The type of state to look up.", required=true) @PathParam(value="eventType") String var2, @Parameter(description="The key of the state to look up.", required=true) @PathParam(value="stateKey") String var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);

    @Operation(summary="Looks up the contents of a state event in a room. If the user is joined to the room then the state is taken from the current state of the room. If the user has left the room then the state is taken from the state of the room when they left.", description="This looks up the state event with the empty state key.", responses={@ApiResponse(responseCode="200", description="The content of the state event.", content={@Content(schema=@Schema(implementation=EventContent.class))}), @ApiResponse(responseCode="403", description="You aren't a member of the room and weren't previously a member of the room.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="The room has no state with the given type or key.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room participation"})
    @GET
    @Secured
    @Path(value="/{roomId}/state/{eventType}")
    public void roomEventWithType(@Parameter(description="The room to look up the state in.", required=true) @PathParam(value="roomId") Id var1, @Parameter(description="The type of state to look up.", required=true) @PathParam(value="eventType") String var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @Operation(summary="Get the state events for the current state of a room.", responses={@ApiResponse(responseCode="200", description="The current state of the room.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Event.class)))}), @ApiResponse(responseCode="403", description="You aren't a member of the room and weren't previously a member of the room.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room participation"})
    @GET
    @Secured
    @Path(value="/{roomId}/state")
    public void roomState(@Parameter(description="The room to look up the state for.", required=true) @PathParam(value="roomId") Id var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="Get the list of members for this room.", responses={@ApiResponse(responseCode="200", description="A list of members of the room. If you are joined to the room then this will be the current members of the room. If you have left the room then this will be the members of the room when you left.", content={@Content(schema=@Schema(implementation=MembersResponse.class))}), @ApiResponse(responseCode="403", description="You aren't a member of the room and weren't previously a member of the room.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room participation"})
    @GET
    @Secured
    @Path(value="/{roomId}/members")
    public void members(@Parameter(description="The room to get the member events for.", required=true) @PathParam(value="roomId") Id var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="This API returns a map of MXIDs to member info objects for members of the room.", description="The current user must be in the room for it to work, unless it is an Application Service in which case any of the AS's users must be in the room. This API is primarily for Application Services and should be faster to respond than/members as it can be implemented more efficiently on the server.", responses={@ApiResponse(responseCode="200", description="A map of MXID to room member objects.", content={@Content(schema=@Schema(implementation=JoinedMembersResponse.class))}), @ApiResponse(responseCode="403", description="You aren't a member of the room.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room participation"})
    @GET
    @Secured
    @Path(value="/{roomId}/joined_members")
    public void joinedMembers(@Parameter(description="The room to get the members of.", required=true) @PathParam(value="roomId") Id var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="This API returns a list of message and state events for a room.", description="It uses pagination query parameters to paginate history in the room.", responses={@ApiResponse(responseCode="200", description="A list of messages with a new token to request more.", content={@Content(schema=@Schema(implementation=Page.class))}), @ApiResponse(responseCode="403", description="You aren't a member of the room.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room participation"})
    @GET
    @Secured
    @Path(value="/{roomId}/messages")
    public void messages(@Parameter(description="The room to get events from.", required=true) @PathParam(value="roomId") Id var1, @Parameter(description="The token to start returning events from. This token can be obtained from a prev_batch token returned for each room by the sync API, or from a start or end token returned by a previous request to this endpoint.", required=true) @QueryParam(value="from") String var2, @Parameter(description="The token to stop returning events at. This token can be obtained from a prev_batch token returned for each room by the sync endpoint, or from a start or end token returned by a previous request to this endpoint.") @QueryParam(value="to") String var3, @Parameter(description="The direction to return events from.", required=true, schema=@Schema(allowableValues={"b", "f"})) @QueryParam(value="dir") String var4, @Parameter(description="The maximum number of events to return.", schema=@Schema(defaultValue="10")) @QueryParam(value="limit") Integer var5, @Parameter(description="A JSON RoomEventFilter to filter returned events with.") @QueryParam(value="filter") String var6, @Context UriInfo var7, @Context HttpHeaders var8, @Suspended AsyncResponse var9, @Context SecurityContext var10);

    @Operation(summary="State events can be sent using this endpoint.", description="These events will be overwritten if (room id), (event type) and (state key) all match. Requests to this endpoint cannot use transaction IDs like other PUT paths because they cannot be differentiated from the state_key. Furthermore, POST is unsupported on state paths. The body of the request should be the content object of the event; the fields in this object will vary depending on the type of event.See Room Events for the m.event specification.", responses={@ApiResponse(responseCode="200", description="An ID for the sent event.", content={@Content(schema=@Schema(implementation=SendEventResponse.class))}), @ApiResponse(responseCode="403", description="The sender doesn't have permission to send the event into the room.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room participation"})
    @PUT
    @Secured
    @Path(value="/{roomId}/state/{eventType}/{stateKey}")
    public void sendEventWithTypeAndState(@Parameter(description="The room to set the state in.", required=true) @PathParam(value="roomId") Id var1, @Parameter(description="The type of event to send.", required=true) @PathParam(value="eventType") String var2, @Parameter(description="The state_key for the state to send. Defaults to the empty string.", required=true) @PathParam(value="stateKey") String var3, @RequestBody(description="event") EventContent var4, @Context UriInfo var5, @Context HttpHeaders var6, @Suspended AsyncResponse var7, @Context SecurityContext var8);

    @Operation(summary="State events can be sent using this endpoint.", description="This endpoint is equivalent to calling /rooms/{roomId}/state/{eventType}/{stateKey} with an empty stateKey. Previous state events with matching (roomId) and (eventType), and empty (stateKey), will be overwritten. Requests to this endpoint cannot use transaction IDs like other PUT paths because they cannot be differentiated from the state_key. Furthermore, POST is unsupported on state paths. The body of the request should be the content object of the event; the fields in this object will vary depending on the type of event. See Room Events for the m.event specification.", responses={@ApiResponse(responseCode="200", description="An ID for the sent event.", content={@Content(schema=@Schema(implementation=SendEventResponse.class))}), @ApiResponse(responseCode="403", description="The sender doesn't have permission to send the event into the room.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room participation"})
    @PUT
    @Secured
    @Path(value="/{roomId}/state/{eventType}")
    public void sendEventWithType(@Parameter(description="The room to set the state in.", required=true) @PathParam(value="roomId") Id var1, @Parameter(description="The type of event to send.", required=true) @PathParam(value="eventType") String var2, @RequestBody(description="Event") EventContent var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);

    @Operation(summary="This endpoint is used to send a message event to a room.", description="Message events allow access to historical events and pagination, making them suited for \"once-off\" activity in a room. The body of the request should be the content object of the event; the fields in this object will vary depending on the type of event. See Room Events for the m. event specification.", responses={@ApiResponse(responseCode="200", description="An ID for the sent event.", content={@Content(schema=@Schema(implementation=SendEventResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room participation"})
    @PUT
    @Secured
    @Path(value="/{roomId}/send/{eventType}/{txnId}")
    public void sendEvent(@Parameter(description="The room to send the event to.", required=true) @PathParam(value="roomId") Id var1, @Parameter(description="The type of event to send.", required=true) @PathParam(value="eventType") String var2, @Parameter(description="The transaction ID for this event. Clients should generate an ID unique across requests with the same access token; it will be used by the server to ensure idempotency of requests.", required=true) @PathParam(value="txnId") String var3, @RequestBody(description="Event") EventContent var4, @Context UriInfo var5, @Context HttpHeaders var6, @Suspended AsyncResponse var7, @Context SecurityContext var8);

    @Operation(summary="Strips all information out of an event which isn't critical to the integrity of the server-side representation of the room.", description="This cannot be undone. Users may redact their own events, and any user with a power level greater than or equal to the redact power level of the room may redact events there.", responses={@ApiResponse(responseCode="200", description="An ID for the redaction event.", content={@Content(schema=@Schema(implementation=SendEventResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room participation"})
    @PUT
    @Secured
    @Path(value="/{roomId}/redact/{eventId}/{txnId}")
    public void redact(@Parameter(description="The room from which to redact the event.", required=true) @PathParam(value="roomId") Id var1, @Parameter(description="The ID of the event to redact.", required=true) @PathParam(value="eventId") Id var2, @Parameter(description="The transaction ID for this event. Clients should generate a unique ID; it will be used by the server to ensure idempotency of requests.", required=true) @PathParam(value="txnId") String var3, @RequestBody(description="The reason for the event being redacted.") RedactRequest var4, @Context UriInfo var5, @Context HttpHeaders var6, @Suspended AsyncResponse var7, @Context SecurityContext var8);
}

