/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.ErrorResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0/login/cas")
public interface CasApi {
    @Operation(summary="A web-based Matrix client should instruct the user's browser to navigate to this endpoint in order to log in via CAS.", description="The server MUST respond with an HTTP redirect to the CAS interface. The URI MUST include a service parameter giving the path of the /login/cas/ticket endpoint (including the redirectUrl query parameter).", responses={@ApiResponse(responseCode="302", description="A redirect to the CAS interface", content={@Content(schema=@Schema(implementation=EmptyResponse.class))})}, tags={"Session management"})
    @GET
    @Path(value="/redirect")
    public void redirect(@Parameter(description="URI to which the user will be redirected after the homeserver has authenticated the user with CAS.", required=true) @QueryParam(value="redirectUrl") String var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Once the CAS server has authenticated the user, it will redirect the browser to this endpoint (assuming /login/cas/redirect gave it the correct service parameter).", description="The server MUST call /proxyValidate on the CAS server, to validate the ticket supplied by the browser. If validation is successful, the server must generate a Matrix login token. It must then respond with an HTTP redirect to the URI given in the redirectUrl parameter, adding a loginToken query parameter giving the generated token. If validation is unsuccessful, the server should respond with a 401 Unauthorized error, the body of which will be displayed to the user.", responses={@ApiResponse(responseCode="302", description="A redirect to the Matrix client.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="401", description="The server was unable to validate the CAS ticket.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, tags={"Session management"})
    @GET
    @Path(value="/ticket")
    public void ticket(@Parameter(description="The redirectUrl originally provided by the client to /login/cas/redirect.", required=true) @QueryParam(value="redirectUrl") String var1, @Parameter(description="CAS authentication ticket", required=true) @QueryParam(value="ticket") String var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5);
}

