/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.ErrorResponse;
import io.github.ma1uta.matrix.RateLimit;
import io.github.ma1uta.matrix.RateLimitedErrorResponse;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.presence.PresenceList;
import io.github.ma1uta.matrix.client.model.presence.PresenceRequest;
import io.github.ma1uta.matrix.client.model.presence.PresenceStatus;
import io.github.ma1uta.matrix.event.Event;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0/presence")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface PresenceApi {
    @Operation(summary="This API sets the given user's presence state. When setting the status, the activity time is updated to reflect that activity; the client does not need to specify the last_active_ago field. You cannot set the presence state of another user.", responses={@ApiResponse(responseCode="200", description="The new presence state was set.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")})
    @PUT
    @RateLimit
    @Secured
    @Path(value="/{userId}/status")
    public void setPresenceStatus(@Parameter(description="The user whose presence state to update.", required=true) @PathParam(value="userId") String var1, @RequestBody(description="JSON body request.") PresenceRequest var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @Operation(summary="Get the given user's presence state.", responses={@ApiResponse(responseCode="200", description="The presence state for this user.", content={@Content(schema=@Schema(implementation=PresenceStatus.class))}), @ApiResponse(responseCode="403", description="You are not allowed to see this user's presence status.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="There is no presence state for this user. This user may not exist or isn't exposing presence information to you.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")})
    @GET
    @Secured
    @Path(value="/{userId}/status")
    public void getPresenceStatus(@Parameter(description="The user whose presence state to get.", required=true) @PathParam(value="userId") String var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Adds or removes users from this presence list.", responses={@ApiResponse(responseCode="200", description="The list was updated.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")})
    @POST
    @RateLimit
    @Secured
    @Path(value="/list/{userId}")
    public void setPresenceList(@Parameter(description="The user whose presence list is being modified.", required=true) @PathParam(value="userId") String var1, @RequestBody(description="JSON body request") PresenceList var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @Operation(summary="Retrieve a list of presence events for every user on this list.", responses={@ApiResponse(responseCode="200", description="A list of presence events for this list.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Event.class)))})})
    @GET
    @Path(value="/list/{userId}")
    public void getPresenceList(@Parameter(description="The user whose presence list should be retrieved.", required=true) @PathParam(value="userId") String var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);
}

