/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.client.model.typing.TypingRequest;
import io.github.ma1uta.matrix.common.EmptyResponse;
import io.github.ma1uta.matrix.common.RateLimit;
import io.github.ma1uta.matrix.common.RateLimitedErrorResponse;
import io.github.ma1uta.matrix.common.Secured;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0/rooms")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface TypingApi {
    @Operation(summary="This tells the server that the user is typing for the next N milliseconds where N is the value specified in the timeout key. Alternatively, if typing is false, it tells the server that the user has stopped typing.", responses={@ApiResponse(responseCode="200", description="The new typing state was set.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room participation"})
    @PUT
    @RateLimit
    @Secured
    @Path(value="/{roomId}/typing/{userId}")
    public void typing(@Parameter(description="The user who has started to type.", required=true) @PathParam(value="roomId") String var1, @Parameter(description="The room in which the user is typing.", required=true) @PathParam(value="userId") String var2, @RequestBody(description="JSON body request.") TypingRequest var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);
}

