/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.bot;

import io.github.ma1uta.matrix.bot.Bot;
import io.github.ma1uta.matrix.bot.BotConfig;
import io.github.ma1uta.matrix.bot.BotDao;
import io.github.ma1uta.matrix.bot.PersistentService;
import io.github.ma1uta.matrix.client.MatrixClient;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class Context<C extends BotConfig, D extends BotDao<C>, S extends PersistentService<D>, E> {
    private final Object monitor = new Object();
    private final MatrixClient matrixClient;
    private final S service;
    private C config;
    private E data;
    private List<Supplier<Void>> shutdownListeners = new ArrayList<Supplier<Void>>();
    private final Bot<C, D, S, E> bot;

    public Context(MatrixClient matrixClient, S service, Bot<C, D, S, E> bot) {
        this.matrixClient = matrixClient;
        this.service = service;
        this.bot = bot;
    }

    public MatrixClient getMatrixClient() {
        return this.matrixClient;
    }

    public C getConfig() {
        return this.config;
    }

    public void setConfig(C config) {
        this.config = config;
    }

    public E getData() {
        return this.data;
    }

    public void setData(E data) {
        this.data = data;
    }

    protected S getService() {
        return this.service;
    }

    public List<Supplier<Void>> getShutdownListeners() {
        return this.shutdownListeners;
    }

    public Bot<C, D, S, E> getBot() {
        return this.bot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInTransaction(BiConsumer<Context<C, D, S, E>, D> action) {
        Object object = this.monitor;
        synchronized (object) {
            ((PersistentService)this.getService()).invoke(dao -> {
                action.accept(this, dao);
                this.setConfig(dao.save(this.getConfig()));
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R runInTransaction(BiFunction<Context<C, D, S, E>, D, R> action) {
        Object object = this.monitor;
        synchronized (object) {
            return (R)((PersistentService)this.getService()).invoke(dao -> {
                Object result = action.apply(this, dao);
                this.setConfig(dao.save(this.getConfig()));
                return result;
            });
        }
    }

    public void addShutdownListener(Supplier<Void> listener) {
        this.getShutdownListeners().add(listener);
    }
}

