/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.application.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.Id;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.application.model.RoomVisibility;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0/directory/list/appservice")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface RoomServiceApi {
    @Operation(summary="Updates the visibility of a given room on the application service's room directory.", description="This API is similar to the room directory visibility API used by clients to update the homeserver's more general room directory.\nThis API requires the use of an application service access token (as_token) instead of a typical client's access_token. This API cannot be invoked by users who are not identified as application services.", responses={@ApiResponse(responseCode="200", description="The room's directory visibility has been updated.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))})})
    @Secured
    @PUT
    @Path(value="/{networkId}/{roomId}")
    public void updateVisibility(@Parameter(description="The protocol (network) ID to update the room list for. This would have been provided by the application service as being listed as a supported protocol.", required=true) @PathParam(value="networkId") String var1, @Parameter(description="The room ID to add to the directory.", required=true) @PathParam(value="roomId") Id var2, @RequestBody(description="JSON body request.", required=true) RoomVisibility var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6);

    public static class Visibility {
        public static final String PUBLIC = "public";
        public static final String PRIVATE = "private";

        protected Visibility() {
        }
    }
}

