/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.application.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.ErrorResponse;
import io.github.ma1uta.matrix.Id;
import io.github.ma1uta.matrix.application.model.TransactionRequest;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/app/v1")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface ApplicationApi {
    @Operation(summary="This API is called by the homeserver when it wants to push an event (or batch of events) to the application service.", description="Note that the application service should distinguish state events from message events via the presence of a state_key, rather than via the event type.", responses={@ApiResponse(responseCode="200", description="The transaction was processed successfully.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))})})
    @PUT
    @Path(value="/transactions/{txnId}")
    public void transaction(@Parameter(name="txnId", description="The transaction ID for this set of events. Homeservers generate these IDs and they are used to ensure idempotency of requests.", required=true) @PathParam(value="txnId") String var1, @RequestBody(description="JSON body request.") TransactionRequest var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5);

    @Operation(summary="This endpoint is invoked by the homeserver on an application service to query the existence of a given room alias.", description="The homeserver will only query room aliases inside the application service's aliases namespace. The homeserver will send this request when it receives a request to join a room alias within the application service's namespace.", responses={@ApiResponse(responseCode="200", description="The application service indicates that this room alias exists. The application service MUST have created a room and associated it with the queried room alias using the client-server API. Additional information about the room such as its name and topic can be set before responding.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="401", description="The homeserver has not supplied credentials to the application service. Optional error information can be included in the body of this response.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="The credentials supplied by the homeserver were rejected.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="The application service indicates that this room alias does not exist. Optional error information can be included in the body of this response.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/rooms/{roomAlias}")
    public void rooms(@Parameter(name="roomAlias", description="The room alias being queried.", required=true) @PathParam(value="roomAlias") Id var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="This endpoint is invoked by the homeserver on an application service to query the existence of a given user ID.", description="The homeserver will only query user IDs inside the application service's users namespace. The homeserver will send this request when it receives an event for an unknown user ID in the application service's namespace.", responses={@ApiResponse(responseCode="200", description="The application service indicates that this user exists. The application service MUST create the user using the client-server API.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="401", description="The homeserver has not supplied credentials to the application service. Optional error information can be included in the body of this response.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="The credentials supplied by the homeserver were rejected.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="The application service indicates that this user does not exist. Optional error information can be included in the body of this response.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/users/{userId}")
    public void users(@Parameter(name="userId", description="The user ID being queried.", required=true) @PathParam(value="userId") Id var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);
}

