/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.worker;

import com.google.common.util.concurrent.RateLimiter;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SyncTaskWorker<T>
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"sync");
    public final LinkedBlockingQueue<T> taskQueue;
    public final ExecutorService threadPool;
    private final RateLimiter rateLimiter;

    public SyncTaskWorker(LinkedBlockingQueue<T> taskQueue, ExecutorService threadPool, RateLimiter rateLimiter) {
        this.taskQueue = taskQueue;
        this.threadPool = threadPool;
        this.rateLimiter = rateLimiter;
    }

    public SyncTaskWorker(ExecutorService threadPool) {
        this.threadPool = threadPool == null ? new ThreadPoolExecutor(40, 40, 60L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy()) : threadPool;
        this.taskQueue = new LinkedBlockingQueue(100);
        this.rateLimiter = RateLimiter.create((double)30.0);
    }

    public abstract void init();

    public abstract List<T> getTaskList();

    public abstract void handleTask(T var1);

    @Override
    public void run() {
        this.init();
        if (this.taskQueue == null) {
            throw new Exception("queue is not initialized");
        }
        if (this.taskQueue.size() == Integer.MAX_VALUE) {
            throw new Exception("size of queue is illegal");
        }
        this.threadPool.execute(this::getTask);
        while (true) {
            T task = this.taskQueue.take();
            this.threadPool.execute(() -> {
                this.rateLimiter.acquire();
                this.handleTask(task);
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    public void getTask() {
        block2: while (true) {
            tasks = this.getTaskList();
            SyncTaskWorker.log.info("getTaskList,tasks:{}", tasks);
            if (CollectionUtils.isEmpty(tasks)) {
                Thread.sleep(1000L);
                continue;
            }
            var2_3 = tasks.iterator();
            while (true) {
                if (var2_3.hasNext()) ** break;
                continue block2;
                task = var2_3.next();
                this.taskQueue.put(task);
            }
            break;
        }
    }
}

